/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.datagen.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.armory_rpgs.datagen.recipe.SmithingUpgradeRecipe;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;

public abstract class SmithingRecipeProvider
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final CompletableFuture<class_7225.class_7874> registryLookup;
    protected final FabricDataOutput dataOutput;
    private final class_7784.class_7489 recipePathResolver;

    public SmithingRecipeProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
        this.recipePathResolver = dataOutput.method_60917(class_7924.field_52178);
    }

    public abstract void generateRecipes(Builder var1);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        Builder builder = new Builder();
        this.generateRecipes(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            JsonElement json = GSON.toJsonTree((Object)entry.recipe);
            Path path = this.recipePathResolver.method_44107(entry.id);
            writes.add(class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String method_10321() {
        return "Smithing Recipe Generator";
    }

    public static class Builder {
        public final List<Entry> entries = new ArrayList<Entry>();

        public Builder add(class_2960 recipeId, SmithingUpgradeRecipe recipe) {
            this.entries.add(new Entry(recipeId, recipe));
            return this;
        }

        public Builder add(String namespace, String path, SmithingUpgradeRecipe recipe) {
            return this.add(class_2960.method_60655((String)namespace, (String)path), recipe);
        }
    }

    public record Entry(class_2960 id, SmithingUpgradeRecipe recipe) {
    }
}

