/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.CombatPlusCore.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.loot.functions.AbstractEnchantmentLootFunction;
import com.provismet.CombatPlusCore.registries.CPCLootFunctionTypes;
import com.provismet.lilylib.container.EnchantmentContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class EnchantRandomlyFromKeyLootFunction
extends AbstractEnchantmentLootFunction {
    public static final MapCodec<EnchantRandomlyFromKeyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> EnchantRandomlyFromKeyLootFunction.createCodec(instance).and((App)class_5321.method_39154((class_5321)class_7924.field_41265).listOf().fieldOf("enchantments").forGetter(function -> function.keys)).apply((Applicative)instance, EnchantRandomlyFromKeyLootFunction::new));
    private final List<class_5321<class_1887>> keys;

    protected EnchantRandomlyFromKeyLootFunction(List<class_5341> conditions, boolean onlyCompatibleItems, List<class_5321<class_1887>> keys) {
        super(conditions, onlyCompatibleItems);
        this.keys = keys;
    }

    public class_5339<? extends class_120> method_29321() {
        return CPCLootFunctionTypes.ENCHANT_FROM_KEY;
    }

    protected class_1799 method_522(class_1799 itemStack, class_47 context) {
        if (this.keys.isEmpty()) {
            return itemStack;
        }
        Stream<class_6880.class_6883> valid = this.keys.stream().map(key -> context.method_299().method_30349().method_46762(class_7924.field_41265).method_46747(key)).filter(entry -> this.isAcceptable(itemStack, (class_6880<class_1887>)entry));
        Optional enchantment = class_156.method_40083(valid.toList(), (class_5819)context.method_294());
        if (enchantment.isEmpty()) {
            return itemStack;
        }
        return this.enchantWithRandomLevel(itemStack, (class_6880<class_1887>)((class_6880)enchantment.get()), context.method_294());
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends AbstractEnchantmentLootFunction.Builder<Builder> {
        private final List<class_5321<class_1887>> keys = new ArrayList<class_5321<class_1887>>();

        protected Builder getThisBuilder() {
            return this;
        }

        public Builder option(class_5321<class_1887> key) {
            this.keys.add(key);
            return this;
        }

        public Builder option(EnchantmentContainer container) {
            this.keys.add((class_5321<class_1887>)container.getKey());
            return this;
        }

        public class_117 method_515() {
            return new EnchantRandomlyFromKeyLootFunction(this.method_526(), this.isOnlyForCompatibleItems(), this.keys);
        }
    }
}

