/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.CombatPlusCore.registries;

import com.provismet.CombatPlusCore.CPCMain;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.CodeExecutionDoubleEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.CodeExecutionSingleEntityEffect;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_9699;

public class LambdaRegistry {
    public static void register() {
        LambdaRegistry.registerSingles();
        LambdaRegistry.registerDoubles();
        LambdaRegistry.registerSingleConditions();
        LambdaRegistry.registerDoubleConditions();
        LambdaRegistry.registerItemConditions();
    }

    private static void registerSingles() {
        LambdaRegistry.register("log", (class_3218 world, int level, class_9699 context, class_1297 user, class_243 pos) -> CPCMain.LOGGER.info("Single Entity Component: {} triggered this log", (Object)user.method_5477().getString()));
    }

    private static void registerDoubles() {
        LambdaRegistry.register("log-charged", (class_3218 world, int level, class_9699 context, class_1297 user, class_1297 target, class_243 pos) -> CPCMain.LOGGER.info("Double Entity Component: {} performed a charged attack on {}", (Object)user.method_5477().getString(), (Object)target.method_5477().getString()));
        LambdaRegistry.register("log-critical", (class_3218 world, int level, class_9699 context, class_1297 user, class_1297 target, class_243 pos) -> CPCMain.LOGGER.info("Double Entity Component: {} performed a critical attack on {}", (Object)user.method_5477().getString(), (Object)target.method_5477().getString()));
        LambdaRegistry.register("log-kill", (class_3218 world, int level, class_9699 context, class_1297 user, class_1297 target, class_243 pos) -> CPCMain.LOGGER.info("Double Entity Component: {} killed {}", (Object)user.method_5477().getString(), (Object)target.method_5477().getString()));
        LambdaRegistry.register("log-block", (class_3218 world, int level, class_9699 context, class_1297 user, class_1297 target, class_243 pos) -> CPCMain.LOGGER.info("Double Entity Component: {} blocked an attack from {}", (Object)user.method_5477().getString(), (Object)target.method_5477().getString()));
    }

    private static void registerSingleConditions() {
        LambdaRegistry.registerSingleCondition("true", entity -> true);
        LambdaRegistry.registerSingleCondition("false", entity -> false);
    }

    private static void registerDoubleConditions() {
        LambdaRegistry.registerDoubleCondition("true", pair -> true);
        LambdaRegistry.registerDoubleCondition("false", pair -> false);
    }

    private static void registerItemConditions() {
        LambdaRegistry.registerItemCondition("true", item -> true);
        LambdaRegistry.registerItemCondition("false", item -> false);
    }

    private static void register(String name, CodeExecutionSingleEntityEffect.Lambda lambda) {
        class_2378.method_10230(CPCRegistries.SINGLE_ENTITY_LAMBDA, (class_2960)CPCMain.identifier(name), (Object)lambda);
    }

    private static void register(String name, CodeExecutionDoubleEntityEffect.Lambda lambda) {
        class_2378.method_10230(CPCRegistries.DOUBLE_ENTITY_LAMBDA, (class_2960)CPCMain.identifier(name), (Object)lambda);
    }

    private static void registerSingleCondition(String name, Predicate<class_1297> predicate) {
        class_2378.method_10230(CPCRegistries.SINGLE_ENTITY_LAMBDA_CONDITION, (class_2960)CPCMain.identifier(name), predicate);
    }

    private static void registerDoubleCondition(String name, Predicate<class_3545<class_1297, class_1297>> predicate) {
        class_2378.method_10230(CPCRegistries.DOUBLE_ENTITY_LAMBDA_CONDITION, (class_2960)CPCMain.identifier(name), predicate);
    }

    private static void registerItemCondition(String name, Predicate<class_1799> predicate) {
        class_2378.method_10230(CPCRegistries.ITEM_LAMBDA_CONDITION, (class_2960)CPCMain.identifier(name), predicate);
    }
}

