/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class AutoCraftingTableBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public static final int CRAFTING_HEIGHT = 3;
    public static final int CRAFTING_WIDTH = 3;
    public static final int CRAFTING_AREA = 9;
    public static final int RECIPE_TIME = 120;
    public static final int EU_TICK = 10;
    public final RebornInventory<AutoCraftingTableBlockEntity> inventory = new RebornInventory(11, "AutoCraftingTableBlockEntity", 64, (MachineBaseBlockEntity)this);
    private final int OUTPUT_SLOT = 9;
    private final int EXTRA_OUTPUT_SLOT = 10;
    public int progress = 0;
    public int maxProgress = 120;
    public long euTick = 10L;
    public long lastSoundTime = 0L;
    public int balanceSlot = 0;
    class_1715 inventoryCrafting = null;
    class_3955 lastRecipe = null;
    class_1799 outputPreview = class_1799.field_8037;
    class_1792[] layoutInv = new class_1792[9];
    public boolean locked = false;

    public AutoCraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.AUTO_CRAFTING_TABLE, pos, state);
    }

    @Nullable
    public class_3955 getCurrentRecipe(class_1715 craftingInventory, class_9694 input) {
        if (this.lastRecipe != null && this.lastRecipe.method_8115((class_9695)input, this.field_11863)) {
            Object[] currentInvLayout;
            if (this.outputPreview == class_1799.field_8037) {
                this.layoutInv = this.getCraftingLayout(craftingInventory);
                this.outputPreview = this.lastRecipe.method_8116((class_9695)input, (class_7225.class_7874)this.field_11863.method_30349());
            } else if (this.lastRecipe instanceof class_1852 && !Arrays.equals(this.layoutInv, currentInvLayout = this.getCraftingLayout(craftingInventory))) {
                this.layoutInv = currentInvLayout;
                this.outputPreview = this.lastRecipe.method_8116((class_9695)input, (class_7225.class_7874)this.field_11863.method_30349());
            }
            return this.lastRecipe;
        }
        Object[] currentInvLayout = this.getCraftingLayout(craftingInventory);
        if (Arrays.equals(this.layoutInv, currentInvLayout)) {
            return null;
        }
        this.layoutInv = currentInvLayout;
        Optional<class_3955> testRecipe = this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_9695)input, this.field_11863).map(class_8786::comp_1933);
        if (testRecipe.isPresent()) {
            this.lastRecipe = testRecipe.get();
            this.outputPreview = this.lastRecipe.method_8116((class_9695)input, (class_7225.class_7874)this.field_11863.method_30349());
            return this.lastRecipe;
        }
        this.outputPreview = class_1799.field_8037;
        return null;
    }

    private class_1792[] getCraftingLayout(class_1715 craftingInventory) {
        class_1792[] layout = new class_1792[9];
        for (int i = 0; i < 9; ++i) {
            layout[i] = craftingInventory.method_5438(i).method_7909();
        }
        return layout;
    }

    private class_1715 getCraftingInventory() {
        if (this.inventoryCrafting == null) {
            this.inventoryCrafting = new class_1715(new class_1703(this, null, -1){

                public class_1799 method_7601(class_1657 player, int index) {
                    return class_1799.field_8037;
                }

                public boolean method_7597(class_1657 playerIn) {
                    return false;
                }
            }, 3, 3);
        }
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.method_5447(i, this.inventory.method_5438(i));
        }
        return this.inventoryCrafting;
    }

    @Nullable
    private class_1799 getRecipeRemainder(class_3955 recipe, class_9694 input) {
        class_2371 remainingStacks = recipe.method_8111((class_9695)input);
        class_1799 recipeReminder = class_1799.field_8037;
        int size = remainingStacks.size();
        for (int slot = 0; slot < size; ++slot) {
            class_1799 reminderStack = (class_1799)remainingStacks.get(slot);
            if (reminderStack.method_7960()) continue;
            recipeReminder = reminderStack.method_7972();
            ++slot;
            while (slot < size) {
                reminderStack = (class_1799)remainingStacks.get(slot);
                if (!reminderStack.method_7960()) {
                    if (ItemUtils.isItemEqual((class_1799)recipeReminder, (class_1799)reminderStack, (boolean)true, (boolean)true)) {
                        recipeReminder.method_7933(reminderStack.method_7947());
                    } else {
                        return null;
                    }
                }
                ++slot;
            }
            break;
        }
        return recipeReminder;
    }

    private boolean hasOutputSpace(class_1799 output, int slot) {
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)stack, (class_1799)output, (boolean)true, (boolean)true)) {
            return stack.method_7914() >= stack.method_7947() + output.method_7947();
        }
        return false;
    }

    private boolean make(class_3955 recipe, class_9694 input, class_1799 recipeReminder) {
        class_2371 ingredients = recipe.method_8117();
        if (ingredients.isEmpty()) {
            input.method_59989().forEach(stack -> stack.method_7934(1));
            if (!recipeReminder.method_7960()) {
                this.moveOutput(recipeReminder, 10);
            }
        } else {
            boolean[] slotUsed = new boolean[9];
            for (int i = 0; i < ingredients.size(); ++i) {
                class_1799 bestSlot;
                class_1856 ingredient = (class_1856)ingredients.get(i);
                if (ingredient.method_8093(bestSlot = this.inventory.method_5438(i)) && !slotUsed[i]) {
                    slotUsed[i] = true;
                    class_1799 remainderStack = this.getRemainderItem(bestSlot);
                    bestSlot.method_7934(1);
                    if (remainderStack.method_7960()) continue;
                    this.moveOutput(remainderStack, 10);
                    continue;
                }
                for (int j = 0; j < 9; ++j) {
                    class_1799 stack2 = this.inventory.method_5438(j);
                    if (!ingredient.method_8093(stack2) || slotUsed[j]) continue;
                    slotUsed[j] = true;
                    class_1799 remainderStack = this.getRemainderItem(stack2);
                    stack2.method_7934(1);
                    if (remainderStack.method_7960()) continue;
                    this.moveOutput(remainderStack, 10);
                }
            }
        }
        this.moveOutput(this.outputPreview, 9);
        return true;
    }

    private void moveOutput(class_1799 stack, int slot) {
        class_1799 currentOutput = this.inventory.method_5438(slot);
        if (currentOutput.method_7960()) {
            this.inventory.method_5447(slot, stack.method_7972());
        } else {
            currentOutput.method_7933(stack.method_7947());
        }
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        return stack.method_7909().getRecipeRemainder(stack);
    }

    private Optional<class_1715> balanceRecipe(class_1715 craftCache, class_3955 currentRecipe) {
        class_1799 sourceStack;
        ++this.balanceSlot;
        if (this.balanceSlot > craftCache.method_5439()) {
            this.balanceSlot = 0;
        }
        if ((sourceStack = this.inventory.method_5438(this.balanceSlot)).method_7960()) {
            return Optional.empty();
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        block0: for (int s = 0; s < currentRecipe.method_8117().size(); ++s) {
            for (int i = 0; i < 9; ++i) {
                if (possibleSlots.contains(i)) continue;
                class_1799 stackInSlot = this.inventory.method_5438(i);
                class_1856 ingredient = (class_1856)currentRecipe.method_8117().get(s);
                if (ingredient == class_1856.field_9017 || !ingredient.method_8093(sourceStack) || stackInSlot.method_7909() != sourceStack.method_7909()) continue;
                possibleSlots.add(i);
                continue block0;
            }
        }
        if (!possibleSlots.isEmpty()) {
            int totalItems = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).sum();
            int slots = possibleSlots.size();
            int[] split = new int[slots];
            int remainder = totalItems % slots;
            Arrays.fill(split, totalItems / slots);
            while (remainder > 0) {
                for (int i = 0; i < split.length; ++i) {
                    if (remainder <= 0) continue;
                    int n = i;
                    split[n] = split[n] + 1;
                    --remainder;
                }
            }
            List slotDistribution = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).boxed().collect(Collectors.toList());
            boolean needsBalance = false;
            for (int required : split) {
                if (slotDistribution.contains(required)) {
                    slotDistribution.remove((Object)required);
                    continue;
                }
                needsBalance = true;
            }
            if (!needsBalance) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        Pair bestSlot = null;
        for (Integer slot : possibleSlots) {
            class_1799 slotStack = this.inventory.method_5438(slot.intValue());
            if (slotStack.method_7960()) {
                bestSlot = Pair.of((Object)slot, (Object)0);
            }
            if (bestSlot == null) {
                bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
                continue;
            }
            if ((Integer)bestSlot.getRight() < slotStack.method_7947()) continue;
            bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
        }
        if ((Integer)bestSlot.getLeft() == this.balanceSlot || ((Integer)bestSlot.getRight()).intValue() == sourceStack.method_7947() || this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7960() || !ItemUtils.isItemEqual((class_1799)sourceStack, (class_1799)this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()), (boolean)true, (boolean)true)) {
            return Optional.empty();
        }
        sourceStack.method_7934(1);
        this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7933(1);
        this.inventory.setHashChanged();
        return Optional.of(this.getCraftingInventory());
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        class_1799 recipeReminder;
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236 || this.getStored() < this.euTick) {
            return;
        }
        class_1715 inventory = this.getCraftingInventory();
        if (inventory.method_5442()) {
            this.progress = 0;
            this.outputPreview = class_1799.field_8037;
            return;
        }
        class_9694 input = this.getRecipeInput(inventory);
        class_3955 recipe = this.getCurrentRecipe(inventory, input);
        if (recipe == null) {
            this.progress = 0;
            return;
        }
        if (!this.hasOutputSpace(this.outputPreview, 9)) {
            return;
        }
        Optional<class_1715> balanceResult = this.balanceRecipe(inventory, recipe);
        balanceResult.ifPresent(craftingInventory -> {
            this.inventoryCrafting = craftingInventory;
        });
        if (this.locked) {
            for (class_1799 stack : input.method_59989()) {
                if (stack.method_7947() != 1) continue;
                return;
            }
        }
        if ((recipeReminder = this.getRecipeRemainder(recipe, input)) == null || !this.hasOutputSpace(recipeReminder, 10)) {
            return;
        }
        if (this.progress >= this.maxProgress) {
            this.progress = 0;
            this.make(recipe, input, recipeReminder);
            if (inventory.method_5442()) {
                this.outputPreview = class_1799.field_8037;
            }
        } else {
            long time;
            if (this.progress == 0) {
                this.maxProgress = Math.max((int)(120.0 * (1.0 - this.getSpeedMultiplier())), 1);
                this.euTick = this.getEuPerTick(10L);
                if (this.getStored() < this.euTick) {
                    return;
                }
            }
            ++this.progress;
            if (!this.isMuffled() && (time = world.method_8510()) - this.lastSoundTime > 120L) {
                this.lastSoundTime = time;
                world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), ModSounds.AUTO_CRAFTING, class_3419.field_15245, 0.3f, 0.8f);
            }
            this.useEnergy(this.euTick);
        }
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.autoCraftingTableMaxEnergy;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.autoCraftingTableMaxInput;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10556("locked", this.locked);
        super.method_11007(tag, registryLookup);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (tag.method_10545("locked")) {
            this.locked = tag.method_10577("locked");
        }
        super.method_11014(tag, registryLookup);
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return TRContent.Machine.AUTO_CRAFTING_TABLE.getStack();
    }

    public RebornInventory<AutoCraftingTableBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("autocraftingtable").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 28, 25).slot(1, 46, 25).slot(2, 64, 25).slot(3, 28, 43).slot(4, 46, 43).slot(5, 64, 43).slot(6, 28, 61).slot(7, 46, 61).slot(8, 64, 61).outputSlot(9, 145, 42).outputSlot(10, 145, 70).syncEnergyValue().sync(class_9135.field_49675, this::getProgress, this::setProgress).sync(class_9135.field_49675, this::getMaxProgress, this::setMaxProgress).sync(class_9135.field_49675, this::getLockedInt, this::setLockedInt).sync(class_1799.field_49268, this::getOutputPreview, this::setOutputPreview).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getMaxProgress() {
        if (this.maxProgress == 0) {
            this.maxProgress = 1;
        }
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public class_1799 getOutputPreview() {
        return this.outputPreview;
    }

    public void setOutputPreview(class_1799 stack) {
        this.outputPreview = stack;
    }

    private class_9694 getRecipeInput(class_1715 craftingInventory) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(craftingInventory.method_5439());
        for (int i = 0; i < craftingInventory.method_5439(); ++i) {
            stacks.add(craftingInventory.method_5438(i));
        }
        return class_9694.method_59986((int)craftingInventory.method_17398(), (int)craftingInventory.method_17397(), stacks);
    }
}

