/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.compat.rei;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import reborncore.common.crafting.RebornFluidRecipe;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.recipe.recipes.BlastFurnaceRecipe;

@Environment(value=EnvType.CLIENT)
public class MachineRecipeDisplay<R extends RebornRecipe>
implements Display {
    private final class_8786<R> entry;
    private final R recipe;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final int energy;
    private int heat = 0;
    private final int time;
    private FluidInstance fluidInstance = null;

    public MachineRecipeDisplay(class_8786<R> entry) {
        this.entry = entry;
        this.recipe = (RebornRecipe)entry.comp_1933();
        this.inputs = CollectionUtils.map((Collection)this.recipe.ingredients(), ing -> EntryIngredients.ofItemStacks((Collection)ing.getPreviewStacks()));
        this.outputs = this.recipe.outputs().stream().map(EntryIngredients::of).collect(Collectors.toList());
        this.time = this.recipe.time();
        this.energy = this.recipe.power();
        if (this.recipe instanceof BlastFurnaceRecipe) {
            this.heat = ((BlastFurnaceRecipe)this.recipe).getHeat();
        }
        if (this.recipe instanceof RebornFluidRecipe) {
            this.fluidInstance = ((RebornFluidRecipe)this.recipe).fluid();
            this.inputs.add(EntryIngredients.of((class_3611)this.fluidInstance.fluid(), (long)this.fluidInstance.getAmount().getRawValue()));
        }
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getHeat() {
        return this.heat;
    }

    public int getTime() {
        return this.time;
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public Optional<class_2960> getDisplayLocation() {
        return Optional.of(this.entry.comp_1932());
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return CategoryIdentifier.of((class_2960)Objects.requireNonNull(class_7923.field_41188.method_10221((Object)this.recipe.method_17716())));
    }
}

