/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.events;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;

@Environment(value=EnvType.CLIENT)
public class ToolTipAssistUtils {
    private static final class_124 instructColour = class_124.field_1078;
    private static final class_124 infoColour = class_124.field_1065;
    private static final class_124 statColour = class_124.field_1065;
    private static final class_124 posColour = class_124.field_1060;
    private static final class_124 negColour = class_124.field_1061;

    public static List<class_2561> getUpgradeStats(TRContent.Upgrades upgradeType, int count, boolean shiftHeld) {
        ArrayList<class_2561> tips = new ArrayList<class_2561>();
        boolean shouldStackCalculate = count > 1;
        switch (upgradeType) {
            case OVERCLOCKER: {
                tips.add(ToolTipAssistUtils.getStatStringUnit(class_1074.method_4662((String)"techreborn.tooltip.upgrade.speed_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateSpeed(TechRebornConfig.overclockerSpeed * 100.0, count, shiftHeld), "%", true));
                tips.add(ToolTipAssistUtils.getStatStringUnit(class_1074.method_4662((String)"techreborn.tooltip.upgrade.energy_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateEnergyIncrease(TechRebornConfig.overclockerPower + 1.0, count, shiftHeld), "x", false));
                break;
            }
            case TRANSFORMER: {
                shouldStackCalculate = false;
                break;
            }
            case ENERGY_STORAGE: {
                tips.add(ToolTipAssistUtils.getStatStringUnit(class_1074.method_4662((String)"techreborn.tooltip.upgrade.storage_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateValue(TechRebornConfig.energyStoragePower, count, shiftHeld), " E", true));
                break;
            }
            case SUPERCONDUCTOR: {
                tips.add(ToolTipAssistUtils.getStatStringUnit(class_1074.method_4662((String)"techreborn.tooltip.upgrade.flow_increase", (Object[])new Object[0]), ToolTipAssistUtils.calculateValue(Math.pow(2.0, TechRebornConfig.superConductorCount + 2.0) * 100.0, count, shiftHeld), "%", true));
            }
        }
        if (shouldStackCalculate && !shiftHeld) {
            tips.add((class_2561)class_2561.method_43470((String)(String.valueOf(instructColour) + class_1074.method_4662((String)"techreborn.tooltip.stack_info", (Object[])new Object[0]))));
        }
        return tips;
    }

    public static void addInfo(String inKey, List<class_2561> list) {
        ToolTipAssistUtils.addInfo(inKey, list, true);
    }

    public static void addInfo(String inKey, List<class_2561> list, boolean hidden) {
        String key = "techreborn.message.info." + inKey;
        if (class_1074.method_4663((String)key)) {
            if (!hidden || class_437.method_25442()) {
                String info = class_1074.method_4662((String)key, (Object[])new Object[0]);
                List<class_5250> infoLines = Arrays.stream(info.split("\\r?\\n")).map(infoLine -> class_2561.method_43470((String)(String.valueOf(infoColour) + infoLine))).toList();
                list.addAll(1, infoLines);
            } else {
                list.add((class_2561)class_2561.method_43470((String)(String.valueOf(instructColour) + class_1074.method_4662((String)"techreborn.tooltip.more_info", (Object[])new Object[0]))));
            }
        }
    }

    private static int calculateValue(double value, int count, boolean shiftHeld) {
        int calculatedVal = shiftHeld ? (int)value * Math.min(count, 4) : (int)value;
        return calculatedVal;
    }

    private static double calculateEnergyIncrease(double value, int count, boolean shiftHeld) {
        double calculatedVal = shiftHeld ? Math.pow(value, Math.min(count, 4)) : value;
        return calculatedVal;
    }

    private static double calculateSpeed(double value, int count, boolean shiftHeld) {
        double calculatedVal = shiftHeld ? Math.min(value * (double)Math.min(count, 4), MachineBaseBlockEntity.SPEED_CAP * 100.0) : value;
        return calculatedVal;
    }

    private static class_2561 getStatStringUnit(String text, double value, String unit, boolean isPositive) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat formatter = new DecimalFormat("##.##", symbols);
        return class_2561.method_43470((String)(String.valueOf(statColour) + text + ": " + String.valueOf(isPositive ? posColour : negColour) + formatter.format(value) + unit));
    }
}

