/*
 * Decompiled with CFR 0.152.
 */
package techreborn.events;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import techreborn.world.OreDepth;

public final class OreDepthSyncHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OreDepthSyncHandler.class);
    private static Map<class_2248, OreDepth> oreDepthMap = new HashMap<class_2248, OreDepth>();

    private OreDepthSyncHandler() {
    }

    public static void setup() {
        PayloadTypeRegistry.configurationS2C().register(OreDepthPayload.ID, OreDepthPayload.PACKET_CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, OreDepthPayload.ID)) {
                List<OreDepth> oreDepths = OreDepth.create(server);
                class_2596 packet = ServerConfigurationNetworking.createS2CPacket((class_8710)new OreDepthPayload(oreDepths));
                handler.method_52391(packet, null);
            } else {
                LOGGER.error("Client cannot receive ore depth packet. This may mean that TechReborn is not installed on the client.");
                handler.method_52396((class_2561)class_2561.method_43470((String)"The TechReborn mod must be installed to play on this server."));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDepths(List<OreDepth> list) {
        Class<OreDepthSyncHandler> clazz = OreDepthSyncHandler.class;
        synchronized (OreDepthSyncHandler.class) {
            oreDepthMap = list.stream().collect(Collectors.toMap(oreDepth -> (class_2248)class_7923.field_41175.method_10223(oreDepth.identifier()), Function.identity()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<class_2248, OreDepth> getOreDepthMap() {
        Class<OreDepthSyncHandler> clazz = OreDepthSyncHandler.class;
        synchronized (OreDepthSyncHandler.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return oreDepthMap;
        }
    }

    public record OreDepthPayload(List<OreDepth> oreDepths) implements class_8710
    {
        public static final class_8710.class_9154<OreDepthPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"techreborn", (String)"ore_depth"));
        public static final class_9139<class_2540, OreDepthPayload> PACKET_CODEC = class_9139.method_56434((class_9139)OreDepth.PACKET_CODEC.method_56433(class_9135.method_56363()), OreDepthPayload::oreDepths, OreDepthPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

