/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.fabric.compat;

import net.fabricmc.loader.api.FabricLoader;
import net.jewelry.compat.AccessoriesCompat;
import net.jewelry.fabric.compat.FabricCompatConfig;
import net.jewelry.fabric.compat.trinkets.TrinketsCompat;
import net.tiny_config.ConfigManager;

public class CompatFeatures {
    private static final ConfigManager<FabricCompatConfig> config = new ConfigManager("fabric_compatibility", (Object)new FabricCompatConfig()).builder().setDirectory("jewelry").sanitize(true).build();
    private static boolean configLoaded = false;

    private static FabricCompatConfig safeConfig() {
        if (!configLoaded) {
            config.refresh();
            configLoaded = true;
        }
        return (FabricCompatConfig)CompatFeatures.config.value;
    }

    public static void init() {
        CompatFeatures.initSlotCompat();
    }

    private static void initSlotCompat() {
        String preferred = CompatFeatures.safeConfig().preferred_slot_mod_id;
        if ("trinkets".equals(preferred) ? CompatFeatures.initTrinkets() : "accessories".equals(preferred) && CompatFeatures.initAccessories()) {
            return;
        }
        if (CompatFeatures.initTrinkets()) {
            return;
        }
        CompatFeatures.initAccessories();
    }

    private static boolean initTrinkets() {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            TrinketsCompat.init();
            return true;
        }
        return false;
    }

    private static boolean initAccessories() {
        if (FabricLoader.getInstance().isModLoaded("accessories")) {
            AccessoriesCompat.init();
            return true;
        }
        return false;
    }
}

