/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.data_gen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class SkillDefinitionGenerator
implements class_2405 {
    private final CompletableFuture<class_7225.class_7874> registryLookup;
    protected final FabricDataOutput dataOutput;
    private static final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(class_2561.class, (Object)new class_2561.class_8822((class_7225.class_7874)class_5455.field_40585)).setPrettyPrinting().create();

    public SkillDefinitionGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generate(Builder var1);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        Builder builder = new Builder();
        this.generate(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            LinkedHashMap<String, Format> content = entry.definitions();
            JsonElement json = gson.toJsonTree(content);
            Path path = this.getFilePath(entry.category());
            writes.add(class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String method_10321() {
        return "Skill Definition Generator";
    }

    private Path getFilePath(class_2960 category) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39367, "puffish_skills/categories/" + category.method_12832()).method_44107(class_2960.method_60655((String)category.method_12836(), (String)"definitions"));
    }

    public static class Builder {
        public final List<Entry> entries = new ArrayList<Entry>();
    }

    public record Entry(class_2960 category, LinkedHashMap<String, Format> definitions) {
    }

    public record RewardAttribute(String attribute, double value, String operation) {
        public static RewardAttribute from(class_6880<class_1320> attribute, class_1322 modifier) {
            String operation = switch (modifier.comp_2450()) {
                case class_1322.class_1323.field_6328 -> "addition";
                case class_1322.class_1323.field_6330 -> "multiply_base";
                case class_1322.class_1323.field_6331 -> "multiply_total";
                default -> throw new IllegalArgumentException("Unknown operation: " + String.valueOf(modifier.comp_2450()));
            };
            String attributeId = ((class_5321)attribute.method_40230().get()).method_29177().toString();
            return new RewardAttribute(attributeId, modifier.comp_2449(), operation);
        }
    }

    public record Reward(String type, Object data) {
    }

    public record IconEffect(String effect) {
    }

    public record IconItem(String item) {
    }

    public record IconTexture(String texture) {
    }

    public record Icon(String type, Object data) {
        public static Icon texture(String texture) {
            return new Icon("texture", new IconTexture(texture));
        }

        public static Icon item(String item) {
            return new Icon("item", new IconItem(item));
        }

        public static Icon effect(String effect) {
            return new Icon("effect", new IconEffect(effect));
        }
    }

    public record Translatable(String translate) {
    }

    public record Format(Translatable title, class_2561 description, Icon icon, List<Reward> rewards, List<String> required_mods) {
    }
}

