/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import fabric.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import fabric.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import fabric.io.github.adytech99.healthindicators.util.ConfigUtils;
import fabric.io.github.adytech99.healthindicators.util.Util;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public class ModCommands {
    @Environment(value=EnvType.CLIENT)
    public static void registerCommands() {
        ClientCommandRegistrationEvent.EVENT.register(ModCommands::configCommands);
        ClientCommandRegistrationEvent.EVENT.register(ModCommands::openModMenuCommand);
    }

    private static void configCommands(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> clientCommandSourceStackCommandDispatcher, class_7157 commandRegistryAccess) {
        clientCommandSourceStackCommandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.literalCommand("healthindicators").then(ModCommands.literalCommand("offset").then(ClientCommandRegistrationEvent.argument((String)"offset", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).display_offset = DoubleArgumentType.getDouble((CommandContext)context, (String)"offset");
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(((ClientCommandRegistrationEvent.ClientCommandSourceStack)context.getSource()).arch$getPlayer(), (class_2561)class_2561.method_43470((String)("Set heart offset to " + Util.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
            return 1;
        })))).then(ModCommands.literalCommand("indicator-type").then(ClientCommandRegistrationEvent.argument((String)"indicator_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("heart");
            builder.suggest("number");
            return builder.buildFuture();
        }).executes(context -> {
            HealthDisplayTypeEnum displayTypeEnum;
            if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("heart")) {
                displayTypeEnum = HealthDisplayTypeEnum.HEARTS;
            } else if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("number")) {
                displayTypeEnum = HealthDisplayTypeEnum.NUMBER;
            } else {
                ConfigUtils.sendMessage(((ClientCommandRegistrationEvent.ClientCommandSourceStack)context.getSource()).arch$getPlayer(), (class_2561)class_2561.method_43470((String)"Unknown argument, please try again."));
                return 1;
            }
            ((ModConfig)ModConfig.HANDLER.instance()).indicator_type = displayTypeEnum;
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(((ClientCommandRegistrationEvent.ClientCommandSourceStack)context.getSource()).arch$getPlayer(), (class_2561)class_2561.method_43470((String)("Set display type to " + String.valueOf((Object)((ModConfig)ModConfig.HANDLER.instance()).indicator_type))));
            return 1;
        })))).then(ModCommands.literalCommand("blacklist").then(ModCommands.literalCommand("add").then(ClientCommandRegistrationEvent.argument((String)"entity_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (class_1297 entity : class_310.method_1551().field_1724.field_17892.method_18112()) {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    builder.suggest(livingEntity.method_5864().toString());
                }
                if (!(entity instanceof class_1657)) continue;
                class_1657 playerEntity = (class_1657)entity;
                builder.suggest(playerEntity.method_5477().getString());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).list.add(StringArgumentType.getString((CommandContext)context, (String)"entity_type"));
            return 1;
        }))))).then(ModCommands.literalCommand("blacklist").then(ModCommands.literalCommand("remove").then(ClientCommandRegistrationEvent.argument((String)"entity_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String string : ((ModConfig)ModConfig.HANDLER.instance()).list) {
                builder.suggest(string);
            }
            return builder.buildFuture();
        }).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).list.remove(StringArgumentType.getString((CommandContext)context, (String)"entity_type"));
            return 1;
        })))));
    }

    private static void openModMenuCommand(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> clientCommandSourceStackCommandDispatcher, class_7157 commandRegistryAccess) {
        clientCommandSourceStackCommandDispatcher.register((LiteralArgumentBuilder)ModCommands.literalCommand("healthindicators").executes(context -> {
            HealthIndicatorsCommon.openConfig();
            return 1;
        }));
    }

    public static LiteralArgumentBuilder<ClientCommandRegistrationEvent.ClientCommandSourceStack> literalCommand(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }
}

