/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators.fabric;

import fabric.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import fabric.io.github.adytech99.healthindicators.RenderTracker;
import fabric.io.github.adytech99.healthindicators.config.Config;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import fabric.io.github.adytech99.healthindicators.fabric.commands.ModCommands;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;

@Environment(value=EnvType.CLIENT)
public class HealthIndicatorsFabric
implements ClientModInitializer {
    public static final String MOD_ID = "healthindicators";
    public static final class_304 HEARTS_RENDERING_ENABLED = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.renderingEnabled", 263, "key.categories.healthindicators"));
    public static final class_304 ARMOR_RENDERING_ENABLED = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.armorRenderingEnabled", 344, "key.categories.healthindicators"));
    public static final class_304 OVERRIDE_ALL_FILTERS = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.overrideAllFilters", 262, "key.categories.healthindicators"));
    public static final class_304 INCREASE_HEART_OFFSET = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.increaseHeartOffset", 265, "key.categories.healthindicators"));
    public static final class_304 DECREASE_HEART_OFFSET = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.decreaseHeartOffset", 264, "key.categories.healthindicators"));
    public static final class_304 OPEN_CONFIG_SCREEN = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.healthindicators.openModMenuConfig", 73, "key.categories.healthindicators"));

    public void onInitializeClient() {
        HealthIndicatorsCommon.init();
        if (((ModConfig)ModConfig.HANDLER.instance()).enable_commands) {
            ModCommands.registerCommands();
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            HealthIndicatorsCommon.tick();
            while (HEARTS_RENDERING_ENABLED.method_1436()) {
                HealthIndicatorsCommon.enableHeartsRendering();
            }
            while (ARMOR_RENDERING_ENABLED.method_1436()) {
                HealthIndicatorsCommon.enableArmorRendering();
            }
            while (INCREASE_HEART_OFFSET.method_1436()) {
                HealthIndicatorsCommon.increaseOffset();
            }
            while (DECREASE_HEART_OFFSET.method_1436()) {
                HealthIndicatorsCommon.decreaseOffset();
            }
            if (OVERRIDE_ALL_FILTERS.method_1434()) {
                HealthIndicatorsCommon.overrideFilters();
            } else if (Config.getOverrideAllFiltersEnabled()) {
                HealthIndicatorsCommon.disableOverrideFilters();
            }
            if (OPEN_CONFIG_SCREEN.method_1436()) {
                HealthIndicatorsCommon.openConfigScreen();
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> RenderTracker.removeFromUUIDS(entity));
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> ModConfig.HANDLER.save());
    }
}

