/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators.fabric.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fabric.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import fabric.io.github.adytech99.healthindicators.RenderTracker;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import fabric.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import fabric.io.github.adytech99.healthindicators.util.ConfigUtils;
import fabric.io.github.adytech99.healthindicators.util.Util;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class ModCommands {
    @Environment(value=EnvType.CLIENT)
    public static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register(ModCommands::configCommands);
        ClientCommandRegistrationCallback.EVENT.register(ModCommands::openModMenuCommand);
    }

    private static void configCommands(CommandDispatcher<FabricClientCommandSource> fabricClientCommandSourceCommandDispatcher, class_7157 commandRegistryAccess) {
        fabricClientCommandSourceCommandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"healthindicators").then(ClientCommandManager.literal((String)"offset").then(ClientCommandManager.argument((String)"offset", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).display_offset = DoubleArgumentType.getDouble((CommandContext)context, (String)"offset");
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)("Set heart offset to " + Util.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
            return 1;
        })))).then(ClientCommandManager.literal((String)"indicator-type").then(ClientCommandManager.argument((String)"indicator_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("heart");
            builder.suggest("number");
            return builder.buildFuture();
        }).executes(context -> {
            HealthDisplayTypeEnum displayTypeEnum;
            if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("heart")) {
                displayTypeEnum = HealthDisplayTypeEnum.HEARTS;
            } else if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("number")) {
                displayTypeEnum = HealthDisplayTypeEnum.NUMBER;
            } else {
                ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)"Unknown argument, please try again."));
                return 1;
            }
            ((ModConfig)ModConfig.HANDLER.instance()).indicator_type = displayTypeEnum;
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)("Set display type to " + String.valueOf((Object)((ModConfig)ModConfig.HANDLER.instance()).indicator_type))));
            return 1;
        })))).then(ClientCommandManager.literal((String)"monitor").then(ClientCommandManager.argument((String)"entity_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (class_1297 entity : ((FabricClientCommandSource)context.getSource()).getWorld().method_18112()) {
                if (entity.method_16914()) {
                    builder.suggest(Objects.requireNonNull(entity.method_5797()).getString());
                }
                if (!entity.method_31747()) continue;
                builder.suggest(Objects.requireNonNull(entity.method_5476()).getString());
            }
            return builder.buildFuture();
        }).executes(context -> {
            if (Util.getEntityFromName(((FabricClientCommandSource)context.getSource()).getWorld(), StringArgumentType.getString((CommandContext)context, (String)"entity_name")) != null) {
                ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)("Now monitoring " + StringArgumentType.getString((CommandContext)context, (String)"entity_name"))));
                RenderTracker.setTrackedEntity((class_1309)Util.getEntityFromName(((FabricClientCommandSource)context.getSource()).getWorld(), StringArgumentType.getString((CommandContext)context, (String)"entity_name")));
            } else {
                ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)("There is no entity named " + StringArgumentType.getString((CommandContext)context, (String)"entity_name") + " in the world. It may have died or gone out of render distance.")));
            }
            return 0;
        })))).then(ClientCommandManager.literal((String)"stop-monitoring").executes(context -> {
            RenderTracker.setTrackedEntity(null);
            ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)"Stopped monitoring "));
            return 0;
        })));
    }

    private static void IndicatorTypeCommand(CommandDispatcher<FabricClientCommandSource> fabricClientCommandSourceCommandDispatcher, class_7157 commandRegistryAccess) {
        fabricClientCommandSourceCommandDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"healthindicators").then(ClientCommandManager.argument((String)"operation", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("indicator_type");
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"indicator_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("heart");
            builder.suggest("number");
            return builder.buildFuture();
        }).executes(context -> {
            HealthDisplayTypeEnum displayTypeEnum;
            if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("heart")) {
                displayTypeEnum = HealthDisplayTypeEnum.HEARTS;
            } else if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("number")) {
                displayTypeEnum = HealthDisplayTypeEnum.NUMBER;
            } else {
                ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)"Unknown argument, please try again."));
                return 1;
            }
            ((ModConfig)ModConfig.HANDLER.instance()).indicator_type = displayTypeEnum;
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(((FabricClientCommandSource)context.getSource()).getPlayer(), (class_2561)class_2561.method_43470((String)("Set display type to " + String.valueOf((Object)((ModConfig)ModConfig.HANDLER.instance()).indicator_type))));
            return 1;
        }))));
    }

    private static void openModMenuCommand(CommandDispatcher<FabricClientCommandSource> fabricClientCommandSourceCommandDispatcher, class_7157 commandRegistryAccess) {
        fabricClientCommandSourceCommandDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"healthindicators").executes(context -> {
            HealthIndicatorsCommon.openConfig();
            return 1;
        }));
    }
}

