/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.io.github.adytech99.healthindicators.RenderTracker;
import fabric.io.github.adytech99.healthindicators.config.Config;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import fabric.io.github.adytech99.healthindicators.enums.ArmorTypeEnum;
import fabric.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import fabric.io.github.adytech99.healthindicators.enums.HeartTypeEnum;
import fabric.io.github.adytech99.healthindicators.util.HeartJumpData;
import fabric.io.github.adytech99.healthindicators.util.RenderUtils;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_757;
import net.minecraft.class_8646;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_922.class})
public abstract class EntityRendererMixin<T extends class_1309, M extends class_583<T>>
extends class_897<T>
implements class_3883<T, M> {
    @Unique
    private final class_310 client = class_310.method_1551();

    protected EntityRendererMixin(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="TAIL")})
    public void render(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo ci) {
        if (RenderTracker.isInUUIDS(livingEntity) || Config.getOverrideAllFiltersEnabled() && !RenderTracker.isInvalid(livingEntity)) {
            if (Config.getHeartsRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS) {
                    this.renderHearts(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.NUMBER) {
                    this.renderNumber(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.DYNAMIC) {
                    if (livingEntity.method_6063() > 100.0f) {
                        this.renderNumber(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                    } else {
                        this.renderHearts(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                    }
                }
            }
            if (Config.getArmorRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                this.renderArmorPoints(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
            }
        }
    }

    @Unique
    private void renderHearts(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_289 tessellator = class_289.method_1348();
        double d = this.field_4676.method_23168(livingEntity);
        int healthRed = class_3532.method_15386((float)livingEntity.method_6032());
        int maxHealth = class_3532.method_15386((float)livingEntity.method_6063());
        int healthYellow = class_3532.method_15386((float)livingEntity.method_6067());
        if (((ModConfig)ModConfig.HANDLER.instance()).percentage_based_health) {
            healthRed = class_3532.method_15386((float)((float)healthRed / (float)maxHealth * (float)((ModConfig)ModConfig.HANDLER.instance()).max_health));
            maxHealth = class_3532.method_15386((float)((ModConfig)ModConfig.HANDLER.instance()).max_health);
            healthYellow = class_3532.method_15386((float)livingEntity.method_6067());
        }
        int heartsRed = class_3532.method_15386((float)((float)healthRed / 2.0f));
        boolean lastRedHalf = (healthRed & 1) == 1;
        int heartsNormal = class_3532.method_15386((float)((float)maxHealth / 2.0f));
        int heartsYellow = class_3532.method_15386((float)((float)healthYellow / 2.0f));
        boolean lastYellowHalf = (healthYellow & 1) == 1;
        int heartsTotal = heartsNormal + heartsYellow;
        int heartsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(heartsTotal, heartsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        double heartDensity = 50.0 - Math.max(4.0 - Math.ceil((double)heartsTotal / (double)heartsPerRow), -3.0) * 5.0;
        double h = 0.0;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            for (int heart = 0; heart < heartsTotal; ++heart) {
                if (heart % heartsPerRow == 0) {
                    h = (double)heart / heartDensity;
                }
                matrixStack.method_22903();
                float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
                class_287 vertexConsumer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                matrixStack.method_22904(0.0, (double)(livingEntity.method_17682() + 0.5f) + h, 0.0);
                if (livingEntity.method_6059(class_1294.field_5924) && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects && HeartJumpData.getWhichHeartJumping(livingEntity) == heart) {
                    matrixStack.method_22904(0.0, (double)(1.15f * scale), 0.0);
                }
                if ((this.method_3921((class_1297)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                        matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.method_22907(this.field_4676.method_24197());
                matrixStack.method_22905(-scale, scale, scale);
                matrixStack.method_22904(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                Matrix4f model = matrixStack.method_23760().method_23761();
                float x = maxX - (float)(heart % heartsPerRow * 8);
                if (isDrawingEmpty == 0) {
                    RenderUtils.drawHeart(model, (class_4588)vertexConsumer, x, HeartTypeEnum.EMPTY, livingEntity);
                } else {
                    HeartTypeEnum type;
                    if (heart < heartsRed) {
                        type = HeartTypeEnum.RED_FULL;
                        if (heart == heartsRed - 1 && lastRedHalf) {
                            type = HeartTypeEnum.RED_HALF;
                        }
                    } else if (heart < heartsNormal) {
                        type = HeartTypeEnum.EMPTY;
                    } else {
                        type = HeartTypeEnum.YELLOW_FULL;
                        if (heart == heartsTotal - 1 && lastYellowHalf) {
                            type = HeartTypeEnum.YELLOW_HALF;
                        }
                    }
                    if (type != HeartTypeEnum.EMPTY) {
                        RenderUtils.drawHeart(model, (class_4588)vertexConsumer, x, type, livingEntity);
                    }
                }
                try {
                    class_9801 builtBuffer = vertexConsumer.method_60794();
                    if (builtBuffer != null) {
                        class_286.method_43433((class_9801)builtBuffer);
                        builtBuffer.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                matrixStack.method_22909();
            }
        }
    }

    @Unique
    private void renderNumber(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        double d = this.field_4676.method_23168(livingEntity);
        String healthText = RenderUtils.getHealthText(livingEntity);
        matrixStack.method_22903();
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        matrixStack.method_46416(0.0f, livingEntity.method_17682() + 0.5f, 0.0f);
        if ((this.method_3921((class_1297)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
            matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            }
        }
        matrixStack.method_22907(this.field_4676.method_24197());
        matrixStack.method_22905(scale, -scale, scale);
        matrixStack.method_22904(0.0, -((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
        class_327 textRenderer = class_310.method_1551().field_1772;
        float x = (float)(-textRenderer.method_1727(healthText)) / 2.0f;
        Matrix4f model = matrixStack.method_23760().method_23761();
        textRenderer.method_27521(healthText, x, 0.0f, ((ModConfig)ModConfig.HANDLER.instance()).number_color.getRGB(), ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_shadow, model, vertexConsumerProvider, class_327.class_6415.field_33993, ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_background_color ? ((ModConfig)ModConfig.HANDLER.instance()).number_display_background_color.getRGB() : 0, light);
        matrixStack.method_22909();
    }

    @Unique
    private void renderArmorPoints(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_289 tessellator = class_289.method_1348();
        double d = this.field_4676.method_23168(livingEntity);
        int armor = class_3532.method_15386((float)livingEntity.method_6096());
        int maxArmor = class_3532.method_15386((float)livingEntity.method_6096());
        if (maxArmor == 0) {
            return;
        }
        int armorPoints = class_3532.method_15386((float)((float)armor / 2.0f));
        boolean lastPointHalf = (armor & 1) == 1;
        int pointsNormal = class_3532.method_15386((float)((float)maxArmor / 2.0f));
        int pointsTotal = 10;
        int pointsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(pointsTotal, pointsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        double pointDensity = 50.0 - Math.max(4.0 - Math.ceil((double)pointsTotal / (double)pointsPerRow), -3.0) * 5.0;
        double h = 0.0;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            for (int pointCount = 0; pointCount < pointsTotal; ++pointCount) {
                if (pointCount % pointsPerRow == 0) {
                    h = (double)pointCount / pointDensity;
                }
                matrixStack.method_22903();
                float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
                class_287 vertexConsumer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                matrixStack.method_22904(0.0, (double)(livingEntity.method_17682() + 0.75f) + h, 0.0);
                if ((this.method_3921((class_1297)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                        matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.method_22907(this.field_4676.method_24197());
                matrixStack.method_22905(-scale, scale, scale);
                matrixStack.method_22904(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                Matrix4f model = matrixStack.method_23760().method_23761();
                float x = maxX - (float)(pointCount % pointsPerRow * 8);
                if (isDrawingEmpty == 0) {
                    EntityRendererMixin.drawArmor(model, (class_4588)vertexConsumer, x, ArmorTypeEnum.EMPTY);
                } else {
                    ArmorTypeEnum type = null;
                    if (pointCount < armorPoints) {
                        type = ArmorTypeEnum.FULL;
                        if (pointCount == armorPoints - 1 && lastPointHalf) {
                            type = ArmorTypeEnum.HALF;
                        }
                    } else if (pointCount < pointsNormal) {
                        type = ArmorTypeEnum.EMPTY;
                    }
                    if (type != null) {
                        EntityRendererMixin.drawArmor(model, (class_4588)vertexConsumer, x, type);
                    }
                }
                try {
                    class_9801 builtBuffer = vertexConsumer.method_60794();
                    if (builtBuffer != null) {
                        class_286.method_43433((class_9801)builtBuffer);
                        builtBuffer.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                matrixStack.method_22909();
            }
        }
    }

    @Unique
    private static void drawArmor(Matrix4f model, class_4588 vertexConsumer, float x, ArmorTypeEnum type) {
        RenderSystem.setShader(class_757::method_34542);
        class_2960 armorIcon = ((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? type.vanillaIcon : type.icon;
        RenderSystem.setShaderTexture((int)0, (class_2960)armorIcon);
        RenderSystem.enableDepthTest();
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float heartSize = 9.0f;
        vertexConsumer.method_22918(model, x, 0.0f - heartSize, 0.0f).method_22913(minU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, 0.0f - heartSize, 0.0f).method_22913(maxU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, 0.0f, 0.0f).method_22913(maxU, minV);
        vertexConsumer.method_22918(model, x, 0.0f, 0.0f).method_22913(minU, minV);
    }

    @Unique
    @Deprecated
    private static void drawVertex(Matrix4f model, class_4588 vertices, float x, float y, float u, float v) {
        vertices.method_22918(model, x, y, 0.0f).method_22913(u, v);
    }
}

