/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators.util;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import fabric.io.github.adytech99.healthindicators.enums.HeartTypeEnum;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class RenderUtils {
    public static void drawHeart(Matrix4f model, class_4588 vertexConsumer, float x, HeartTypeEnum type, class_1309 livingEntity) {
        Object additionalIconEffects = "";
        if (type != HeartTypeEnum.YELLOW_FULL && type != HeartTypeEnum.YELLOW_HALF && type != HeartTypeEnum.EMPTY && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects) {
            additionalIconEffects = HeartTypeEnum.addStatusIcon(livingEntity) + HeartTypeEnum.addHardcoreIcon(livingEntity);
        }
        class_2960 heartIcon = class_2960.method_60655((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        class_2960 vanillaHeartIcon = class_2960.method_60655((String)"healthindicators", (String)("textures/gui/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)(((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? vanillaHeartIcon : heartIcon));
        RenderSystem.enableDepthTest();
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float heartSize = 9.0f;
        vertexConsumer.method_22918(model, x, 0.0f - heartSize, 0.0f).method_22913(minU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, 0.0f - heartSize, 0.0f).method_22913(maxU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, 0.0f, 0.0f).method_22913(maxU, minV);
        vertexConsumer.method_22918(model, x, 0.0f, 0.0f).method_22913(minU, minV);
    }

    public static String getHealthText(class_1309 livingEntity) {
        float health = class_3532.method_15386((float)livingEntity.method_6032());
        float maxHealth = class_3532.method_15386((float)livingEntity.method_6063());
        float absorption = class_3532.method_15386((float)livingEntity.method_6067());
        if (((ModConfig)ModConfig.HANDLER.instance()).percentage_based_health) {
            return (health + absorption) / maxHealth * 100.0f + " %";
        }
        return health + absorption + " / " + maxHealth;
    }
}

