/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import neoforge.io.github.adytech99.healthindicators.RenderTracker;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.util.RenderUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class HudRenderer {
    private static final RandomSource random = RandomSource.create();

    public static void onHudRender(GuiGraphics drawContext, DeltaTracker renderTickCounter) {
        HudRenderer.drawNumberHealthGUIIndicator(RenderTracker.getTrackedEntity(), ((ModConfig)ModConfig.HANDLER.instance()).number_color, 20, 20, ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_shadow, drawContext);
    }

    private static void drawHeart(GuiGraphics context, HudHeartType type, int x, int y, boolean hardcore, boolean blinking, boolean half) {
        RenderSystem.enableBlend();
        context.blitSprite(type.getTexture(hardcore, half, blinking), 50, 50, 9, 9);
        RenderSystem.disableBlend();
    }

    public static void drawNumberHealthGUIIndicator(LivingEntity livingEntity, Color textColor, int x, int y, boolean shadow, GuiGraphics drawContext) {
        String name = String.valueOf(livingEntity.getCustomName() != null ? livingEntity.getCustomName().tryCollapseToString() : livingEntity.getDisplayName().getString());
        drawContext.drawString(Minecraft.getInstance().font, name, x, y, textColor.getRGB(), shadow);
        drawContext.drawString(Minecraft.getInstance().font, RenderUtils.getHealthText(livingEntity), x, y + 10, textColor.getRGB(), shadow);
    }

    static enum HudHeartType {
        CONTAINER(ResourceLocation.withDefaultNamespace((String)"hud/heart/container"), ResourceLocation.withDefaultNamespace((String)"hud/heart/container_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/container"), ResourceLocation.withDefaultNamespace((String)"hud/heart/container_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/container_hardcore"), ResourceLocation.withDefaultNamespace((String)"hud/heart/container_hardcore_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/container_hardcore"), ResourceLocation.withDefaultNamespace((String)"hud/heart/container_hardcore_blinking")),
        NORMAL(ResourceLocation.withDefaultNamespace((String)"hud/heart/full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/half_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_half_blinking")),
        POISONED(ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_half_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_hardcore_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_hardcore_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/poisoned_hardcore_half_blinking")),
        WITHERED(ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_half_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_hardcore_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_hardcore_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/withered_hardcore_half_blinking")),
        ABSORBING(ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_half_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_hardcore_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_hardcore_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_hardcore_half_blinking")),
        FROZEN(ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_half_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_hardcore_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_hardcore_full_blinking"), ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_hardcore_half"), ResourceLocation.withDefaultNamespace((String)"hud/heart/frozen_hardcore_half_blinking"));

        private final ResourceLocation fullTexture;
        private final ResourceLocation fullBlinkingTexture;
        private final ResourceLocation halfTexture;
        private final ResourceLocation halfBlinkingTexture;
        private final ResourceLocation hardcoreFullTexture;
        private final ResourceLocation hardcoreFullBlinkingTexture;
        private final ResourceLocation hardcoreHalfTexture;
        private final ResourceLocation hardcoreHalfBlinkingTexture;

        private HudHeartType(ResourceLocation fullTexture, ResourceLocation fullBlinkingTexture, ResourceLocation halfTexture, ResourceLocation halfBlinkingTexture, ResourceLocation hardcoreFullTexture, ResourceLocation hardcoreFullBlinkingTexture, ResourceLocation hardcoreHalfTexture, ResourceLocation hardcoreHalfBlinkingTexture) {
            this.fullTexture = fullTexture;
            this.fullBlinkingTexture = fullBlinkingTexture;
            this.halfTexture = halfTexture;
            this.halfBlinkingTexture = halfBlinkingTexture;
            this.hardcoreFullTexture = hardcoreFullTexture;
            this.hardcoreFullBlinkingTexture = hardcoreFullBlinkingTexture;
            this.hardcoreHalfTexture = hardcoreHalfTexture;
            this.hardcoreHalfBlinkingTexture = hardcoreHalfBlinkingTexture;
        }

        public ResourceLocation getTexture(boolean hardcore, boolean half, boolean blinking) {
            if (!hardcore) {
                if (half) {
                    return blinking ? this.halfBlinkingTexture : this.halfTexture;
                }
                return blinking ? this.fullBlinkingTexture : this.fullTexture;
            }
            if (half) {
                return blinking ? this.hardcoreHalfBlinkingTexture : this.hardcoreHalfTexture;
            }
            return blinking ? this.hardcoreFullBlinkingTexture : this.hardcoreFullTexture;
        }

        static HudHeartType fromEntityState(LivingEntity livingEntity) {
            HudHeartType heartType = livingEntity.hasEffect(MobEffects.POISON) ? POISONED : (livingEntity.hasEffect(MobEffects.WITHER) ? WITHERED : (livingEntity.isFullyFrozen() ? FROZEN : NORMAL));
            return heartType;
        }
    }
}

