/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import neoforge.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import neoforge.io.github.adytech99.healthindicators.util.ConfigUtils;
import neoforge.io.github.adytech99.healthindicators.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ModCommands {
    @OnlyIn(value=Dist.CLIENT)
    public static void registerCommands() {
        ClientCommandRegistrationEvent.EVENT.register(ModCommands::configCommands);
        ClientCommandRegistrationEvent.EVENT.register(ModCommands::openModMenuCommand);
    }

    private static void configCommands(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> clientCommandSourceStackCommandDispatcher, CommandBuildContext commandRegistryAccess) {
        clientCommandSourceStackCommandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.literalCommand("healthindicators").then(ModCommands.literalCommand("offset").then(ClientCommandRegistrationEvent.argument((String)"offset", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).display_offset = DoubleArgumentType.getDouble((CommandContext)context, (String)"offset");
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(((ClientCommandRegistrationEvent.ClientCommandSourceStack)context.getSource()).arch$getPlayer(), (Component)Component.literal((String)("Set heart offset to " + Util.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
            return 1;
        })))).then(ModCommands.literalCommand("indicator-type").then(ClientCommandRegistrationEvent.argument((String)"indicator_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("heart");
            builder.suggest("number");
            return builder.buildFuture();
        }).executes(context -> {
            HealthDisplayTypeEnum displayTypeEnum;
            if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("heart")) {
                displayTypeEnum = HealthDisplayTypeEnum.HEARTS;
            } else if (StringArgumentType.getString((CommandContext)context, (String)"indicator_type").equals("number")) {
                displayTypeEnum = HealthDisplayTypeEnum.NUMBER;
            } else {
                ConfigUtils.sendMessage(((ClientCommandRegistrationEvent.ClientCommandSourceStack)context.getSource()).arch$getPlayer(), (Component)Component.literal((String)"Unknown argument, please try again."));
                return 1;
            }
            ((ModConfig)ModConfig.HANDLER.instance()).indicator_type = displayTypeEnum;
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(((ClientCommandRegistrationEvent.ClientCommandSourceStack)context.getSource()).arch$getPlayer(), (Component)Component.literal((String)("Set display type to " + String.valueOf((Object)((ModConfig)ModConfig.HANDLER.instance()).indicator_type))));
            return 1;
        })))).then(ModCommands.literalCommand("blacklist").then(ModCommands.literalCommand("add").then(ClientCommandRegistrationEvent.argument((String)"entity_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (Entity entity : Minecraft.getInstance().player.clientLevel.entitiesForRendering()) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    builder.suggest(livingEntity.getType().toString());
                }
                if (!(entity instanceof Player)) continue;
                Player playerEntity = (Player)entity;
                builder.suggest(playerEntity.getName().getString());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).list.add(StringArgumentType.getString((CommandContext)context, (String)"entity_type"));
            return 1;
        }))))).then(ModCommands.literalCommand("blacklist").then(ModCommands.literalCommand("remove").then(ClientCommandRegistrationEvent.argument((String)"entity_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String string : ((ModConfig)ModConfig.HANDLER.instance()).list) {
                builder.suggest(string);
            }
            return builder.buildFuture();
        }).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).list.remove(StringArgumentType.getString((CommandContext)context, (String)"entity_type"));
            return 1;
        })))));
    }

    private static void openModMenuCommand(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> clientCommandSourceStackCommandDispatcher, CommandBuildContext commandRegistryAccess) {
        clientCommandSourceStackCommandDispatcher.register((LiteralArgumentBuilder)ModCommands.literalCommand("healthindicators").executes(context -> {
            HealthIndicatorsCommon.openConfig();
            return 1;
        }));
    }

    public static LiteralArgumentBuilder<ClientCommandRegistrationEvent.ClientCommandSourceStack> literalCommand(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }
}

