/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.config;

import com.google.gson.Gson;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class Config {
    private static final Gson GSON = new Gson();
    public static final String CONFIG_FILE = "healthindicators.json";
    private static Config INSTANCE = new Config();
    private boolean heartsRenderingEnabled = true;
    private boolean armorRenderingEnabled = true;
    private boolean overrideAllFiltersEnabled = false;

    public static boolean getRenderingEnabled() {
        return Config.INSTANCE.heartsRenderingEnabled || Config.INSTANCE.armorRenderingEnabled;
    }

    public static boolean getHeartsRenderingEnabled() {
        return Config.INSTANCE.heartsRenderingEnabled;
    }

    public static void setHeartsRenderingEnabled(boolean renderingEnabled) {
        Config.INSTANCE.heartsRenderingEnabled = renderingEnabled;
        Config.save();
    }

    public static boolean getArmorRenderingEnabled() {
        return Config.INSTANCE.armorRenderingEnabled;
    }

    public static void setArmorRenderingEnabled(boolean armorRenderingEnabled) {
        Config.INSTANCE.armorRenderingEnabled = armorRenderingEnabled;
        Config.save();
    }

    public static boolean getOverrideAllFiltersEnabled() {
        return Config.INSTANCE.overrideAllFiltersEnabled;
    }

    public static void setOverrideAllFiltersEnabled(boolean overrideAllFiltersEnabled) {
        Config.INSTANCE.overrideAllFiltersEnabled = overrideAllFiltersEnabled;
        Config.save();
    }

    public static void load() {
        try (BufferedReader reader = new BufferedReader(new FileReader(Platform.getConfigFolder().resolve(CONFIG_FILE).toFile()));){
            Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config != null) {
                INSTANCE = config;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(Platform.getConfigFolder().resolve(CONFIG_FILE).toFile()));){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

