/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import neoforge.io.github.adytech99.healthindicators.RenderTracker;
import neoforge.io.github.adytech99.healthindicators.config.Config;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.enums.ArmorTypeEnum;
import neoforge.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import neoforge.io.github.adytech99.healthindicators.enums.HeartTypeEnum;
import neoforge.io.github.adytech99.healthindicators.util.HeartJumpData;
import neoforge.io.github.adytech99.healthindicators.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.DisplaySlot;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class EntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    @Unique
    private final Minecraft client = Minecraft.getInstance();

    protected EntityRendererMixin(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    public void render(T livingEntity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, CallbackInfo ci) {
        if (RenderTracker.isInUUIDS(livingEntity) || Config.getOverrideAllFiltersEnabled() && !RenderTracker.isInvalid(livingEntity)) {
            if (Config.getHeartsRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS) {
                    this.renderHearts(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.NUMBER) {
                    this.renderNumber(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.DYNAMIC) {
                    if (livingEntity.getMaxHealth() > 100.0f) {
                        this.renderNumber(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                    } else {
                        this.renderHearts(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                    }
                }
            }
            if (Config.getArmorRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                this.renderArmorPoints(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
            }
        }
    }

    @Unique
    private void renderHearts(T livingEntity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        Tesselator tessellator = Tesselator.getInstance();
        double d = this.entityRenderDispatcher.distanceToSqr(livingEntity);
        int healthRed = Mth.ceil((float)livingEntity.getHealth());
        int maxHealth = Mth.ceil((float)livingEntity.getMaxHealth());
        int healthYellow = Mth.ceil((float)livingEntity.getAbsorptionAmount());
        if (((ModConfig)ModConfig.HANDLER.instance()).percentage_based_health) {
            healthRed = Mth.ceil((float)((float)healthRed / (float)maxHealth * (float)((ModConfig)ModConfig.HANDLER.instance()).max_health));
            maxHealth = Mth.ceil((float)((ModConfig)ModConfig.HANDLER.instance()).max_health);
            healthYellow = Mth.ceil((float)livingEntity.getAbsorptionAmount());
        }
        int heartsRed = Mth.ceil((float)((float)healthRed / 2.0f));
        boolean lastRedHalf = (healthRed & 1) == 1;
        int heartsNormal = Mth.ceil((float)((float)maxHealth / 2.0f));
        int heartsYellow = Mth.ceil((float)((float)healthYellow / 2.0f));
        boolean lastYellowHalf = (healthYellow & 1) == 1;
        int heartsTotal = heartsNormal + heartsYellow;
        int heartsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(heartsTotal, heartsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        double heartDensity = 50.0 - Math.max(4.0 - Math.ceil((double)heartsTotal / (double)heartsPerRow), -3.0) * 5.0;
        double h = 0.0;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            for (int heart = 0; heart < heartsTotal; ++heart) {
                if (heart % heartsPerRow == 0) {
                    h = (double)heart / heartDensity;
                }
                matrixStack.pushPose();
                float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
                BufferBuilder vertexConsumer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                matrixStack.translate(0.0, (double)(livingEntity.getBbHeight() + 0.5f) + h, 0.0);
                if (livingEntity.hasEffect(MobEffects.REGENERATION) && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects && HeartJumpData.getWhichHeartJumping(livingEntity) == heart) {
                    matrixStack.translate(0.0, (double)(1.15f * scale), 0.0);
                }
                if ((this.shouldShowName((Entity)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof Player && livingEntity != this.client.player) && d <= 4096.0) {
                    matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof Player && livingEntity.getCommandSenderWorld().getScoreboard().getDisplayObjective(DisplaySlot.BELOW_NAME) != null) {
                        matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
                matrixStack.scale(-scale, scale, scale);
                matrixStack.translate(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                Matrix4f model = matrixStack.last().pose();
                float x = maxX - (float)(heart % heartsPerRow * 8);
                if (isDrawingEmpty == 0) {
                    RenderUtils.drawHeart(model, (VertexConsumer)vertexConsumer, x, HeartTypeEnum.EMPTY, livingEntity);
                } else {
                    HeartTypeEnum type;
                    if (heart < heartsRed) {
                        type = HeartTypeEnum.RED_FULL;
                        if (heart == heartsRed - 1 && lastRedHalf) {
                            type = HeartTypeEnum.RED_HALF;
                        }
                    } else if (heart < heartsNormal) {
                        type = HeartTypeEnum.EMPTY;
                    } else {
                        type = HeartTypeEnum.YELLOW_FULL;
                        if (heart == heartsTotal - 1 && lastYellowHalf) {
                            type = HeartTypeEnum.YELLOW_HALF;
                        }
                    }
                    if (type != HeartTypeEnum.EMPTY) {
                        RenderUtils.drawHeart(model, (VertexConsumer)vertexConsumer, x, type, livingEntity);
                    }
                }
                try {
                    MeshData builtBuffer = vertexConsumer.build();
                    if (builtBuffer != null) {
                        BufferUploader.drawWithShader((MeshData)builtBuffer);
                        builtBuffer.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                matrixStack.popPose();
            }
        }
    }

    @Unique
    private void renderNumber(T livingEntity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        double d = this.entityRenderDispatcher.distanceToSqr(livingEntity);
        String healthText = RenderUtils.getHealthText(livingEntity);
        matrixStack.pushPose();
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        matrixStack.translate(0.0f, livingEntity.getBbHeight() + 0.5f, 0.0f);
        if ((this.shouldShowName((Entity)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof Player && livingEntity != this.client.player) && d <= 4096.0) {
            matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
            if (d < 100.0 && livingEntity instanceof Player && livingEntity.getCommandSenderWorld().getScoreboard().getDisplayObjective(DisplaySlot.BELOW_NAME) != null) {
                matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
            }
        }
        matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrixStack.scale(scale, -scale, scale);
        matrixStack.translate(0.0, -((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
        Font textRenderer = Minecraft.getInstance().font;
        float x = (float)(-textRenderer.width(healthText)) / 2.0f;
        Matrix4f model = matrixStack.last().pose();
        textRenderer.drawInBatch(healthText, x, 0.0f, ((ModConfig)ModConfig.HANDLER.instance()).number_color.getRGB(), ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_shadow, model, vertexConsumerProvider, Font.DisplayMode.NORMAL, ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_background_color ? ((ModConfig)ModConfig.HANDLER.instance()).number_display_background_color.getRGB() : 0, light);
        matrixStack.popPose();
    }

    @Unique
    private void renderArmorPoints(T livingEntity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        Tesselator tessellator = Tesselator.getInstance();
        double d = this.entityRenderDispatcher.distanceToSqr(livingEntity);
        int armor = Mth.ceil((float)livingEntity.getArmorValue());
        int maxArmor = Mth.ceil((float)livingEntity.getArmorValue());
        if (maxArmor == 0) {
            return;
        }
        int armorPoints = Mth.ceil((float)((float)armor / 2.0f));
        boolean lastPointHalf = (armor & 1) == 1;
        int pointsNormal = Mth.ceil((float)((float)maxArmor / 2.0f));
        int pointsTotal = 10;
        int pointsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(pointsTotal, pointsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        double pointDensity = 50.0 - Math.max(4.0 - Math.ceil((double)pointsTotal / (double)pointsPerRow), -3.0) * 5.0;
        double h = 0.0;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            for (int pointCount = 0; pointCount < pointsTotal; ++pointCount) {
                if (pointCount % pointsPerRow == 0) {
                    h = (double)pointCount / pointDensity;
                }
                matrixStack.pushPose();
                float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
                BufferBuilder vertexConsumer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                matrixStack.translate(0.0, (double)(livingEntity.getBbHeight() + 0.75f) + h, 0.0);
                if ((this.shouldShowName((Entity)livingEntity) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof Player && livingEntity != this.client.player) && d <= 4096.0) {
                    matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof Player && livingEntity.getCommandSenderWorld().getScoreboard().getDisplayObjective(DisplaySlot.BELOW_NAME) != null) {
                        matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
                matrixStack.scale(-scale, scale, scale);
                matrixStack.translate(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                Matrix4f model = matrixStack.last().pose();
                float x = maxX - (float)(pointCount % pointsPerRow * 8);
                if (isDrawingEmpty == 0) {
                    EntityRendererMixin.drawArmor(model, (VertexConsumer)vertexConsumer, x, ArmorTypeEnum.EMPTY);
                } else {
                    ArmorTypeEnum type = null;
                    if (pointCount < armorPoints) {
                        type = ArmorTypeEnum.FULL;
                        if (pointCount == armorPoints - 1 && lastPointHalf) {
                            type = ArmorTypeEnum.HALF;
                        }
                    } else if (pointCount < pointsNormal) {
                        type = ArmorTypeEnum.EMPTY;
                    }
                    if (type != null) {
                        EntityRendererMixin.drawArmor(model, (VertexConsumer)vertexConsumer, x, type);
                    }
                }
                try {
                    MeshData builtBuffer = vertexConsumer.build();
                    if (builtBuffer != null) {
                        BufferUploader.drawWithShader((MeshData)builtBuffer);
                        builtBuffer.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                matrixStack.popPose();
            }
        }
    }

    @Unique
    private static void drawArmor(Matrix4f model, VertexConsumer vertexConsumer, float x, ArmorTypeEnum type) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        ResourceLocation armorIcon = ((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? type.vanillaIcon : type.icon;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)armorIcon);
        RenderSystem.enableDepthTest();
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float heartSize = 9.0f;
        vertexConsumer.addVertex(model, x, 0.0f - heartSize, 0.0f).setUv(minU, maxV);
        vertexConsumer.addVertex(model, x - heartSize, 0.0f - heartSize, 0.0f).setUv(maxU, maxV);
        vertexConsumer.addVertex(model, x - heartSize, 0.0f, 0.0f).setUv(maxU, minV);
        vertexConsumer.addVertex(model, x, 0.0f, 0.0f).setUv(minU, minV);
    }

    @Unique
    @Deprecated
    private static void drawVertex(Matrix4f model, VertexConsumer vertices, float x, float y, float u, float v) {
        vertices.addVertex(model, x, y, 0.0f).setUv(u, v);
    }
}

