/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.neoforge.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import neoforge.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import neoforge.io.github.adytech99.healthindicators.RenderTracker;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import neoforge.io.github.adytech99.healthindicators.util.ConfigUtils;
import neoforge.io.github.adytech99.healthindicators.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;

public class ModCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterClientCommandsEvent event) {
        ModCommands.registerConfigCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ModCommands.registerOpenConfigCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void registerConfigCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"healthindicators").then(Commands.literal((String)"offset").then(Commands.argument((String)"offset", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ((ModConfig)ModConfig.HANDLER.instance()).display_offset = DoubleArgumentType.getDouble((CommandContext)context, (String)"offset");
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(Minecraft.getInstance().player, (Component)Component.literal((String)("Set heart offset to " + Util.truncate(((ModConfig)ModConfig.HANDLER.instance()).display_offset, 2))));
            return 1;
        })))).then(Commands.literal((String)"indicator-type").then(Commands.argument((String)"indicator_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("heart");
            builder.suggest("number");
            return builder.buildFuture();
        }).executes(context -> {
            HealthDisplayTypeEnum displayTypeEnum;
            String type = StringArgumentType.getString((CommandContext)context, (String)"indicator_type");
            if ("heart".equals(type)) {
                displayTypeEnum = HealthDisplayTypeEnum.HEARTS;
            } else if ("number".equals(type)) {
                displayTypeEnum = HealthDisplayTypeEnum.NUMBER;
            } else {
                ConfigUtils.sendMessage(Minecraft.getInstance().player, (Component)Component.literal((String)"Unknown argument, please try again."));
                return 1;
            }
            ((ModConfig)ModConfig.HANDLER.instance()).indicator_type = displayTypeEnum;
            ModConfig.HANDLER.save();
            ConfigUtils.sendMessage(Minecraft.getInstance().player, (Component)Component.literal((String)("Set display type to " + String.valueOf((Object)((ModConfig)ModConfig.HANDLER.instance()).indicator_type))));
            return 1;
        })))).then(Commands.literal((String)"monitor").then(Commands.argument((String)"entity_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (Entity entity : Minecraft.getInstance().level.entitiesForRendering()) {
                if (entity.hasCustomName()) {
                    builder.suggest(Objects.requireNonNull(entity.getCustomName()).getString());
                }
                if (!entity.isAlwaysTicking()) continue;
                builder.suggest(Objects.requireNonNull(entity.getDisplayName()).getString());
            }
            return builder.buildFuture();
        }).executes(context -> {
            assert (Minecraft.getInstance().level != null);
            if (Util.getEntityFromName(Minecraft.getInstance().level, StringArgumentType.getString((CommandContext)context, (String)"entity_name")) != null) {
                ConfigUtils.sendMessage(Minecraft.getInstance().player, (Component)Component.literal((String)("Now monitoring " + StringArgumentType.getString((CommandContext)context, (String)"entity_name"))));
                RenderTracker.setTrackedEntity((LivingEntity)Util.getEntityFromName(Minecraft.getInstance().level, StringArgumentType.getString((CommandContext)context, (String)"entity_name")));
            } else {
                ConfigUtils.sendMessage(Minecraft.getInstance().player, (Component)Component.literal((String)("There is no entity named " + StringArgumentType.getString((CommandContext)context, (String)"entity_name") + " in the world. It may have died or gone out of render distance.")));
            }
            return 0;
        })))).then(Commands.literal((String)"stop-monitoring").executes(context -> {
            RenderTracker.setTrackedEntity(null);
            ConfigUtils.sendMessage(Minecraft.getInstance().player, (Component)Component.literal((String)"Stopped monitoring "));
            return 0;
        })));
    }

    public static void registerOpenConfigCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"healthindicators").executes(context -> {
            HealthIndicatorsCommon.openConfig();
            return 1;
        }));
    }
}

