/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.enums.HeartTypeEnum;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public class RenderUtils {
    public static void drawHeart(Matrix4f model, VertexConsumer vertexConsumer, float x, HeartTypeEnum type, LivingEntity livingEntity) {
        Object additionalIconEffects = "";
        if (type != HeartTypeEnum.YELLOW_FULL && type != HeartTypeEnum.YELLOW_HALF && type != HeartTypeEnum.EMPTY && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects) {
            additionalIconEffects = HeartTypeEnum.addStatusIcon(livingEntity) + HeartTypeEnum.addHardcoreIcon(livingEntity);
        }
        ResourceLocation heartIcon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        ResourceLocation vanillaHeartIcon = ResourceLocation.fromNamespaceAndPath((String)"healthindicators", (String)("textures/gui/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? vanillaHeartIcon : heartIcon));
        RenderSystem.enableDepthTest();
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float heartSize = 9.0f;
        vertexConsumer.addVertex(model, x, 0.0f - heartSize, 0.0f).setUv(minU, maxV);
        vertexConsumer.addVertex(model, x - heartSize, 0.0f - heartSize, 0.0f).setUv(maxU, maxV);
        vertexConsumer.addVertex(model, x - heartSize, 0.0f, 0.0f).setUv(maxU, minV);
        vertexConsumer.addVertex(model, x, 0.0f, 0.0f).setUv(minU, minV);
    }

    public static String getHealthText(LivingEntity livingEntity) {
        float health = Mth.ceil((float)livingEntity.getHealth());
        float maxHealth = Mth.ceil((float)livingEntity.getMaxHealth());
        float absorption = Mth.ceil((float)livingEntity.getAbsorptionAmount());
        if (((ModConfig)ModConfig.HANDLER.instance()).percentage_based_health) {
            return (health + absorption) / maxHealth * 100.0f + " %";
        }
        return health + absorption + " / " + maxHealth;
    }
}

