/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.config.elements.ElementBase;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.MachineFacing;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractConfigPopupElement
extends ElementBase {
    private final int height;
    private final String[] pencils;
    private int pencilWidth;
    private int fixIndex = Integer.MAX_VALUE;
    private boolean mouseDown = false;
    private final boolean[] mouseIn = new boolean[]{false, false, false, false, false, false};
    private final MachineFacing[] mouseBoxFacingMap = new MachineFacing[]{MachineFacing.UP, MachineFacing.FRONT, MachineFacing.RIGHT, MachineFacing.LEFT, MachineFacing.DOWN, MachineFacing.BACK};
    private final int[][] mouseBoxMap = new int[][]{{23, 4}, {23, 23}, {42, 23}, {4, 23}, {23, 42}, {42, 42}};
    @Nullable
    public String pencil;

    public AbstractConfigPopupElement(int x, int y, int height, class_4730 sprite, int textureWidth, int textureHeight, String[] pencils) {
        super(x, y, sprite, textureWidth, textureHeight);
        this.height = height;
        this.pencils = pencils;
        int space = 75 - pencils.length;
        this.pencilWidth = space / pencils.length;
        if (space % this.pencilWidth != 0) {
            ++this.pencilWidth;
            this.fixIndex = space % pencils.length;
        }
    }

    @Override
    public boolean isMouseWithinRect(GuiBase<?> gui, double mouseX, double mouseY) {
        return AbstractConfigPopupElement.isInRect(gui, this.getX() - 8, this.getY(), 84, 79, mouseX, mouseY);
    }

    @Override
    public final void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
        drawContext.method_51448().method_22903();
        int x = this.adjustX(gui, this.getX() - 8);
        int y = this.adjustY(gui, this.getY() - 7);
        gui.builder.drawDefaultBackground(drawContext, x, y, 84, this.height);
        drawContext.method_51448().method_22909();
        super.draw(drawContext, gui, mouseX, mouseY);
        MachineBaseBlockEntity machine = (MachineBaseBlockEntity)gui.be;
        class_2680 state = machine.method_11010();
        class_2680 defaultState = state.method_26204().method_9564();
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_1087 model = dispatcher.method_3351().method_3335(defaultState);
        this.drawState(drawContext, gui, model, defaultState, dispatcher, 4, 23, class_7833.field_40716.rotationDegrees(90.0f), 0, 0);
        this.drawState(drawContext, gui, model, defaultState, dispatcher, 23, 4, class_7833.field_40713.rotationDegrees(90.0f), 0, 0);
        this.drawState(drawContext, gui, model, defaultState, dispatcher, 23, 23, null, 0, 0);
        this.drawState(drawContext, gui, model, defaultState, dispatcher, 23, 26, class_7833.field_40714.rotationDegrees(90.0f), 0, 16);
        this.drawState(drawContext, gui, model, defaultState, dispatcher, 42, 23, class_7833.field_40716.rotationDegrees(90.0f), 0, 0);
        this.drawState(drawContext, gui, model, defaultState, dispatcher, 26, 42, class_7833.field_40716.rotationDegrees(180.0f), 16, 0);
        if (this.mouseDown) {
            for (int i = 0; i < 6; ++i) {
                if (!this.isInBox(this.mouseBoxMap[i][0], this.mouseBoxMap[i][1], 16, 16, mouseX, mouseY, gui)) continue;
                if (this.mouseIn[i]) break;
                this.mouseIn[i] = true;
                this.cycleConfig(this.mouseBoxFacingMap[i].getFacing(gui.getMachine()), gui);
                break;
            }
        }
        this.drawSateColor(drawContext, gui, MachineFacing.UP.getFacing(machine), 22, -1);
        this.drawSateColor(drawContext, gui, MachineFacing.FRONT.getFacing(machine), 22, 18);
        this.drawSateColor(drawContext, gui, MachineFacing.DOWN.getFacing(machine), 22, 37);
        this.drawSateColor(drawContext, gui, MachineFacing.RIGHT.getFacing(machine), 41, 18);
        this.drawSateColor(drawContext, gui, MachineFacing.BACK.getFacing(machine), 41, 37);
        this.drawSateColor(drawContext, gui, MachineFacing.LEFT.getFacing(machine), 3, 18);
        this.drawPencil(drawContext, gui, mouseX, mouseY, x, y + 71);
    }

    @Override
    public final boolean onClick(GuiBase<?> gui, double mouseX, double mouseY) {
        this.mouseDown = true;
        for (int i = 0; i < 6; ++i) {
            if (!this.isInBox(this.mouseBoxMap[i][0], this.mouseBoxMap[i][1], 16, 16, mouseX, mouseY, gui)) continue;
            this.mouseIn[i] = true;
            this.cycleConfig(this.mouseBoxFacingMap[i].getFacing(gui.getMachine()), gui);
            return true;
        }
        int rectX = -2;
        int rectWidth = this.pencilWidth - 2;
        for (String pencil : this.pencils) {
            if (this.isInBox(rectX, 65, rectWidth, 11, mouseX, mouseY, gui)) {
                this.pencil = pencil.equals(this.pencil) ? null : pencil;
                return true;
            }
            rectX += this.pencilWidth + 1;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        this.mouseDown = false;
        Arrays.fill(this.mouseIn, false);
        return true;
    }

    protected abstract void cycleConfig(class_2350 var1, GuiBase<?> var2);

    protected abstract void drawSateColor(class_332 var1, GuiBase<?> var2, class_2350 var3, int var4, int var5);

    protected boolean isInBox(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY, GuiBase<?> guiBase) {
        return AbstractConfigPopupElement.isInRect(guiBase, rectX += this.getX(), rectY += this.getY(), rectWidth, rectHeight, pointX, pointY);
    }

    protected void drawState(class_332 drawContext, GuiBase<?> gui, class_1087 model, class_2680 actualState, class_776 dispatcher, int x, int y, Quaternionf quaternion, int paddingLeft, int paddingTop) {
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
        int left = gui.getGuiLeft() + this.getX() + x;
        int top = gui.getGuiTop() + this.getY() + y;
        Vector3f vector3f = positionMatrix.transformPosition((float)(left + paddingLeft), (float)(top + paddingTop), 0.0f, new Vector3f());
        Vector3f vector3f2 = positionMatrix.transformPosition((float)(left + paddingLeft + 16), (float)(top + paddingTop + 16), 0.0f, new Vector3f());
        drawContext.method_44379(class_3532.method_15375((float)vector3f.x), class_3532.method_15375((float)vector3f.y), class_3532.method_15375((float)vector3f2.x), class_3532.method_15375((float)vector3f2.y));
        matrixStack.method_22903();
        matrixStack.method_46416((float)(left + 8), (float)(top + 8), 0.0f);
        matrixStack.method_22905(16.0f, 16.0f, 16.0f);
        matrixStack.method_46416(0.5f, 0.5f, 0.0f);
        matrixStack.method_22905(-1.0f, -1.0f, 0.0f);
        if (quaternion != null) {
            matrixStack.method_22907(quaternion);
        }
        class_4597.class_4598 immediate = drawContext.method_51450();
        dispatcher.method_3350().method_3367(matrixStack.method_23760(), immediate.getBuffer(class_1921.method_23577()), actualState, model, 1.0f, 1.0f, 1.0f, class_4608.method_23210((float)15.0f), class_4608.field_21444);
        immediate.method_22993();
        matrixStack.method_22909();
        drawContext.method_44380();
    }

    protected abstract int getPencilColor(String var1);

    protected void drawPencil(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY, int x, int y) {
        int mx = mouseX - gui.getGuiLeft();
        int my = mouseY - gui.getGuiTop();
        x += 5;
        int y2 = y + 13;
        int y3 = y + 3;
        class_327 textRenderer = gui.getTextRenderer();
        int len = this.pencils.length;
        for (int i = 0; i < len; ++i) {
            int color;
            String pencil = this.pencils[i];
            int x2 = x + (i >= this.fixIndex ? this.pencilWidth - 1 : this.pencilWidth);
            if (pencil.equals(this.pencil)) {
                color = this.getPencilColor(pencil);
            } else if (mx >= x && mx <= x2 && my >= y && my < y2) {
                drawContext.method_51438(textRenderer, (class_2561)class_2561.method_43471((String)("reborncore.gui.slotconfig." + pencil)), mx, my);
                color = mx != x2 ? -7631989 : 0x668B8B8B;
            } else {
                color = 0x668B8B8B;
            }
            drawContext.method_25294(x, y, x2, y2, color);
            class_2561 letter = class_2561.method_30163((String)pencil.substring(0, 1));
            int x3 = x + (this.pencilWidth - textRenderer.method_27525((class_5348)letter)) / 2;
            drawContext.method_51439(textRenderer, letter, x3, y3, -1, false);
            x = x2 + 1;
        }
    }
}

