/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_4730;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.config.elements.ElementBase;

@Environment(value=EnvType.CLIENT)
public abstract class ParentElement
extends ElementBase {
    protected final List<ElementBase> elements = new ArrayList<ElementBase>();

    public ParentElement(int x, int y, class_4730 sprite, int textureWidth, int textureHeight) {
        super(x, y, sprite, textureWidth, textureHeight);
    }

    @Override
    public void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
        super.draw(drawContext, gui, mouseX, mouseY);
        this.elements.forEach(elementBase -> elementBase.draw(drawContext, gui, mouseX, mouseY));
    }

    @Override
    public boolean onClick(GuiBase<?> gui, double mouseX, double mouseY) {
        for (ElementBase element : Lists.reverse(this.elements)) {
            if (!element.isMouseWithinRect(gui, mouseX, mouseY) || !element.onClick(gui, mouseX, mouseY)) continue;
            return true;
        }
        return super.onClick(gui, mouseX, mouseY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        for (ElementBase element : Lists.reverse(this.elements)) {
            if (!element.mouseReleased(mouseX, mouseY, state)) continue;
            return true;
        }
        return false;
    }
}

