/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.fluid;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.Tank;

public class FluidUtils {
    @NotNull
    public static class_3611 fluidFromBlock(class_2248 block) {
        if (block instanceof class_2404) {
            class_2404 fluidBlock = (class_2404)block;
            return fluidBlock.field_11279;
        }
        return class_3612.field_15906;
    }

    public static List<class_3611> getAllFluids() {
        return class_7923.field_41173.method_10220().collect(Collectors.toList());
    }

    public static boolean drainContainers(Tank tank, class_1263 inventory, int inputSlot, int outputSlot) {
        return FluidUtils.drainContainers(tank, inventory, inputSlot, outputSlot, false);
    }

    public static boolean drainContainers(Tank tank, class_1263 inventory, int inputSlot, int outputSlot, boolean voidFluid) {
        Storage<FluidVariant> itemStorage = FluidUtils.getItemFluidStorage(inventory, inputSlot, outputSlot);
        if (voidFluid) {
            try (Transaction tx = Transaction.openOuter();){
                boolean didSomething = false;
                for (StorageView view : itemStorage) {
                    if (view.isResourceBlank()) continue;
                    didSomething |= view.extract((Object)((FluidVariant)view.getResource()), Long.MAX_VALUE, (TransactionContext)tx) > 0L;
                }
                tx.commit();
                boolean bl = didSomething;
                return bl;
            }
        }
        return StorageUtil.move(itemStorage, (Storage)tank, fv -> true, (long)Long.MAX_VALUE, null) > 0L;
    }

    public static boolean fillContainers(Tank source, class_1263 inventory, int inputSlot, int outputSlot) {
        return StorageUtil.move((Storage)source, FluidUtils.getItemFluidStorage(inventory, inputSlot, outputSlot), fv -> true, (long)Long.MAX_VALUE, null) > 0L;
    }

    private static Storage<FluidVariant> getItemFluidStorage(class_1263 inventory, int inputSlot, int outputSlot) {
        SingleSlotStorage output;
        InventoryStorage invWrapper = InventoryStorage.of((class_1263)inventory, null);
        final SingleSlotStorage input = invWrapper.getSlot(inputSlot);
        ContainerItemContext context = new ContainerItemContext(){
            final /* synthetic */ SingleSlotStorage val$output;
            {
                this.val$output = singleSlotStorage2;
            }

            public SingleSlotStorage<ItemVariant> getMainSlot() {
                return input;
            }

            public long insertOverflow(ItemVariant itemVariant, long maxAmount, TransactionContext transactionContext) {
                return this.val$output.insert((Object)itemVariant, maxAmount, transactionContext);
            }

            public long insert(ItemVariant itemVariant, long maxAmount, TransactionContext transaction) {
                return this.insertOverflow(itemVariant, maxAmount, transaction);
            }

            public List<SingleSlotStorage<ItemVariant>> getAdditionalSlots() {
                return List.of();
            }
        };
        Storage storage = (Storage)context.find(FluidStorage.ITEM);
        return storage != null ? storage : Storage.empty();
    }

    public static boolean fluidEquals(@NotNull class_3611 fluid, @NotNull class_3611 fluid1) {
        return fluid == fluid1;
    }

    public static boolean isContainer(class_1799 stack) {
        return ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
    }

    public static boolean isContainerEmpty(class_1799 stack) {
        Storage fluidStorage = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
        if (fluidStorage == null) {
            return false;
        }
        try (Transaction tx = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
            for (StorageView view : fluidStorage) {
                if (view.isResourceBlank() || view.getAmount() <= 0L) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static boolean containsMatchingFluid(class_1799 stack, Predicate<class_3611> predicate) {
        Storage fluidStorage = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
        if (fluidStorage == null) {
            return false;
        }
        try (Transaction tx = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
            for (StorageView view : fluidStorage) {
                if (view.isResourceBlank() || view.getAmount() <= 0L || !predicate.test(((FluidVariant)view.getResource()).getFluid())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean interactWithFluidHandler(class_1657 playerIn, Tank tank) {
        return false;
    }

    public static String getFluidName(@NotNull FluidInstance fluidInstance) {
        return FluidUtils.getFluidName(fluidInstance.fluid());
    }

    public static String getFluidName(@NotNull class_3611 fluid) {
        return class_2561.method_43471((String)fluid.method_15785().method_15759().method_26204().method_9539()).getString();
    }
}

