/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.screen.Syncable;
import reborncore.common.util.serialization.SerializationUtil;

public class Tank
extends SnapshotParticipant<FluidInstance>
implements Syncable,
SingleSlotStorage<FluidVariant> {
    private final String name;
    private FluidInstance fluidInstance = new FluidInstance();
    private final FluidValue capacity;

    public Tank(String name, FluidValue capacity) {
        this.name = name;
        this.capacity = capacity;
    }

    @NotNull
    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    @NotNull
    public class_3611 getFluid() {
        return this.getFluidInstance().fluid();
    }

    public FluidValue getFluidValueCapacity() {
        return this.capacity;
    }

    public FluidValue getFreeSpace() {
        return this.getFluidValueCapacity().subtract(this.getFluidAmount());
    }

    public boolean canFit(class_3611 fluid, FluidValue amount) {
        return (this.isEmpty() || this.getFluid() == fluid) && this.getFreeSpace().equalOrMoreThan(amount);
    }

    public boolean isEmpty() {
        return this.getFluidInstance().isEmpty();
    }

    public boolean isFull() {
        return !this.getFluidInstance().isEmpty() && this.getFluidInstance().getAmount().equalOrMoreThan(this.getFluidValueCapacity());
    }

    public final class_2487 write(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        class_2487 tankData = SerializationUtil.writeNbt(FluidInstance.CODEC, this.fluidInstance, wrapperLookup);
        nbt.method_10566(this.name, (class_2520)tankData);
        return nbt;
    }

    public void setFluidAmount(FluidValue amount) {
        if (!this.fluidInstance.isEmptyFluid()) {
            this.modifyFluid(fluidInstance -> fluidInstance.withAmount(amount));
        }
    }

    public final Tank read(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        if (nbt.method_10545(this.name)) {
            this.setFluid(class_3612.field_15906);
            class_2487 tankData = nbt.method_10562(this.name);
            this.fluidInstance = SerializationUtil.parseNbt(FluidInstance.CODEC, tankData, wrapperLookup, () -> FluidInstance.EMPTY, "tank data");
        }
        return this;
    }

    public void setFluid(@NotNull class_3611 f) {
        this.modifyFluid(fluidInstance -> fluidInstance.withFluid(f));
    }

    @Override
    public void configureSync(Syncable.Context context) {
        context.sync(FluidInstance.PACKET_CODEC, this::getFluidInstance, this::setFluidInstance);
    }

    public FluidValue getFluidAmount() {
        return this.getFluidInstance().getAmount();
    }

    public void modifyFluid(UnaryOperator<FluidInstance> operator) {
        this.setFluidInstance((FluidInstance)operator.apply(this.fluidInstance));
    }

    public void setFluidInstance(@NotNull FluidInstance fluidInstance) {
        this.fluidInstance = fluidInstance;
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
        FluidVariant currentVariant = this.getResource();
        if (currentVariant.equals((Object)insertedVariant) || currentVariant.isBlank()) {
            long insertedAmount = Math.min(maxAmount, this.getCapacity() - this.getAmount());
            if (insertedAmount > 0L) {
                this.updateSnapshots(transaction);
                if (currentVariant.isBlank()) {
                    this.modifyFluid(fluidInstance -> fluidInstance.withAmount(FluidValue.EMPTY));
                }
                this.modifyFluid(fluidInstance -> fluidInstance.withFluid(insertedVariant.getFluid()).addAmount(FluidValue.fromRaw(insertedAmount)));
            }
            return insertedAmount;
        }
        return 0L;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)extractedVariant, (long)maxAmount);
        FluidVariant currentVariant = this.getResource();
        if (extractedVariant.equals((Object)currentVariant)) {
            long extractedAmount = Math.min(maxAmount, this.getAmount());
            if (extractedAmount > 0L) {
                this.updateSnapshots(transaction);
                this.modifyFluid(fluidInstance -> fluidInstance.subtractAmount(FluidValue.fromRaw(extractedAmount)));
            }
            return extractedAmount;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return this.fluidInstance.fluidVariant();
    }

    public long getAmount() {
        return this.fluidInstance.getAmount().getRawValue();
    }

    public long getCapacity() {
        return this.getFluidValueCapacity().getRawValue();
    }

    protected FluidInstance createSnapshot() {
        return this.fluidInstance;
    }

    protected void readSnapshot(FluidInstance snapshot) {
        this.setFluidInstance(snapshot);
    }
}

