/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.config;

import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.ManagerLocator;
import com.fibermc.essentialcommands.playerdata.PlayerDataManager;
import com.fibermc.essentialcommands.types.RespawnCondition;
import dev.jpcode.eccore.config.Config;
import dev.jpcode.eccore.config.ConfigOption;
import dev.jpcode.eccore.config.ConfigUtil;
import dev.jpcode.eccore.config.Option;
import dev.jpcode.eccore.config.StringSerializable;
import dev.jpcode.eccore.config.expression.Expression;
import dev.jpcode.eccore.config.expression.PatternMatchingExpressionReader;
import dev.jpcode.eccore.util.TextUtil;
import dev.jpcode.eccore.util.TimeUtil;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public final class EssentialCommandsConfig
extends Config<EssentialCommandsConfig> {
    @ConfigOption
    public final Option<class_2583> FORMATTING_DEFAULT = new Option("formatting_default", (Object)ConfigUtil.parseStyle((String)"gold"), ConfigUtil::parseStyle, ConfigUtil::serializeStyle);
    @ConfigOption
    public final Option<class_2583> FORMATTING_ACCENT = new Option("formatting_accent", (Object)ConfigUtil.parseStyle((String)"light_purple"), ConfigUtil::parseStyle, ConfigUtil::serializeStyle);
    @ConfigOption
    public final Option<class_2583> FORMATTING_ERROR = new Option("formatting_error", (Object)ConfigUtil.parseStyle((String)"red"), ConfigUtil::parseStyle, ConfigUtil::serializeStyle);
    @ConfigOption
    public final Option<class_2561> NICKNAME_PREFIX = new Option("nickname_prefix", (Object)TextUtil.parseText((String)"{\"text\":\"~\",\"color\":\"red\"}"), TextUtil::parseText, t -> class_2561.class_2562.method_10867((class_2561)t, (class_7225.class_7874)class_5455.field_40585));
    @ConfigOption
    public final Option<Boolean> ENABLE_BACK = new Option("enable_back", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_HOME = new Option("enable_home", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_SPAWN = new Option("enable_spawn", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_TPA = new Option("enable_tpa", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_WARP = new Option("enable_warp", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_NICK = new Option("enable_nick", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_RTP = new Option("enable_rtp", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_FLY = new Option("enable_fly", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_INVULN = new Option("enable_invuln", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_WORKBENCH = new Option("enable_workbench", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_ANVIL = new Option("enable_anvil", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_ENDERCHEST = new Option("enable_enderchest", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_WASTEBIN = new Option("enable_wastebin", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_ESSENTIALSX_CONVERT = new Option("enable_experimental_essentialsx_converter", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_TOP = new Option("enable_top", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_GAMETIME = new Option("enable_gametime", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_MOTD = new Option("enable_motd", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_AFK = new Option("enable_afk", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_DAY = new Option("enable_day", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_RULES = new Option("enable_rules", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_BED = new Option("enable_bed", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_FEED = new Option("enable_feed", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_HEAL = new Option("enable_heal", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_EXTINGUISH = new Option("enable_extinguish", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_SUICIDE = new Option("enable_suicide", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_NIGHT = new Option("enable_night", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_REPAIR = new Option("enable_repair", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_NEAR = new Option("enable_near", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> ENABLE_DELETE_ALL_PLAYER_DATA = new Option("enable_delete_all_player_data", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<List<Integer>> HOME_LIMIT = new Option("home_limit", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(5)), ConfigUtil.arrayParser(ConfigUtil::parseInt));
    @ConfigOption
    public final Option<Double> TELEPORT_COOLDOWN = new Option("teleport_cooldown", (Object)1.0, ConfigUtil::parseDouble);
    @ConfigOption
    public final Option<Double> TELEPORT_DELAY = new Option("teleport_delay", (Object)0.0, ConfigUtil::parseDouble);
    @ConfigOption
    public final Option<Boolean> ALLOW_BACK_ON_DEATH = new Option("allow_back_on_death", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Integer> TELEPORT_REQUEST_DURATION = new Option("teleport_request_duration", (Object)60, ConfigUtil::parseInt);
    @ConfigOption
    public final Option<Boolean> USE_PERMISSIONS_API = new Option("use_permissions_api", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> CHECK_FOR_UPDATES = new Option("check_for_updates", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> TELEPORT_INTERRUPT_ON_DAMAGED = new Option("teleport_interrupt_on_damaged", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> TELEPORT_INTERRUPT_ON_MOVE = new Option("teleport_interrupt_on_move", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Double> TELEPORT_INTERRUPT_ON_MOVE_AMOUNT = new Option("teleport_interrupt_on_move_max_blocks", (Object)3.0, ConfigUtil::parseDouble);
    @ConfigOption
    public final Option<Boolean> ALLOW_TELEPORT_BETWEEN_DIMENSIONS = new Option("allow_teleport_between_dimensions", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> OPS_BYPASS_TELEPORT_RULES = new Option("ops_bypass_teleport_rules", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> NICKNAMES_IN_PLAYER_LIST = new Option("nicknames_in_player_list", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Integer> NICKNAME_MAX_LENGTH = new Option("nickname_max_length", (Object)32, ConfigUtil::parseInt);
    @ConfigOption
    public final Option<Boolean> NICKNAME_ABOVE_HEAD = new Option("nickname_above_head", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Integer> RTP_RADIUS = new Option("rtp_radius", (Object)1000, ConfigUtil::parseInt);
    @ConfigOption
    public final Option<Integer> RTP_MIN_RADIUS = new Option("rtp_min_radius", (Object)((Integer)this.RTP_RADIUS.getValue()), s -> ConfigUtil.parseIntOrDefault((String)s, (int)((Integer)this.RTP_RADIUS.getValue())));
    @ConfigOption
    public final Option<Integer> RTP_COOLDOWN = new Option("rtp_cooldown", (Object)30, ConfigUtil::parseInt);
    @ConfigOption
    public final Option<Integer> RTP_MAX_ATTEMPTS = new Option("rtp_max_attempts", (Object)15, ConfigUtil::parseInt);
    @ConfigOption
    public final Option<List<String>> RTP_ENABLED_WORLDS = new Option("rtp_enabled_worlds", List.of(class_1937.field_25179.method_29177().method_12832()), ConfigUtil.arrayParser(Object::toString));
    @ConfigOption
    public final Option<Boolean> BROADCAST_TO_OPS = new Option("broadcast_to_ops", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> NICK_REVEAL_ON_HOVER = new Option("nick_reveal_on_hover", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> GRANT_LOWEST_NUMERIC_BY_DEFAULT = new Option("grant_lowest_numeric_by_default", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<String> LANGUAGE = new Option("language", (Object)"en_us", String::toString);
    @ConfigOption
    public final Option<String> MOTD = new Option("motd", (Object)"<yellow>Welcome to our server <blue>%player:displayname%</blue>!\nPlease read the rules.</yellow>", String::toString);
    @ConfigOption
    public final Option<class_2561> AFK_PREFIX = new Option("afk_prefix", (Object)class_2561.method_43470((String)"[AFK] ").method_27692(class_124.field_1080), TextUtil::parseText, t -> class_2561.class_2562.method_10867((class_2561)t, (class_7225.class_7874)class_5455.field_40585));
    @ConfigOption
    public final Option<Boolean> INVULN_WHILE_AFK = new Option("invuln_while_afk", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> AUTO_AFK_ENABLED = new Option("auto_afk_enabled", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Integer> AUTO_AFK_TICKS = new Option("auto_afk_time", (Object)TimeUtil.durationToTicks((Duration)Duration.ofMinutes(15L)), ConfigUtil::parseDurationToTicks, ConfigUtil::serializeTicksAsDuration);
    @ConfigOption
    public final Option<Boolean> REGISTER_TOP_LEVEL_COMMANDS = new Option("register_top_level_commands", (Object)true, Boolean::parseBoolean);
    @ConfigOption
    public final Option<List<String>> EXCLUDED_TOP_LEVEL_COMMANDS = new Option("excluded_top_level_commands", List.of(), ConfigUtil.arrayParser(Object::toString));
    @ConfigOption
    public final Option<Expression<RespawnCondition>> RESPAWN_AT_EC_SPAWN = new Option("respawn_at_ec_spawn", (Object)Expression.of((Object)((Object)RespawnCondition.Never)), str -> str.isBlank() ? Expression.of((Object)((Object)RespawnCondition.Never)) : PatternMatchingExpressionReader.parse((String)str, RespawnCondition::valueOf), StringSerializable::serialize);
    @ConfigOption
    public final Option<Boolean> PERSIST_BACK_LOCATION = new Option("persist_back_location", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Boolean> RECHECK_PLAYER_ABILITY_PERMISSIONS_ON_DIMENSION_CHANGE = new Option("recheck_player_ability_permissions_on_dimension_change", (Object)false, Boolean::parseBoolean);
    @ConfigOption
    public final Option<Integer> FLY_MAX_SPEED = new Option("fly_max_speed", (Object)5, ConfigUtil::parseInt);
    @ConfigOption
    public final Option<Integer> NEAR_COMMAND_DEFAULT_RADIUS = new Option("near_command_default_radius", (Object)200, ConfigUtil::parseInt);
    @ConfigOption
    public final Option<Integer> NEAR_COMMAND_MAX_RADIUS = new Option("near_command_max_radius", (Object)200, ConfigUtil::parseInt);
    private final HashSet<class_5321<class_1937>> validRtpWorldIds = new HashSet();

    public EssentialCommandsConfig(Path savePath, String displayName, String documentationLink) {
        super(savePath, displayName, documentationLink);
        this.HOME_LIMIT.changeEvent.register(newValue -> {
            ECPerms.Registry.Group.home_limit_group = ECPerms.makeNumericPermissionGroup("essentialcommands.home.limit", newValue);
        });
        this.NICKNAMES_IN_PLAYER_LIST.changeEvent.register(ign -> PlayerDataManager.getInstance().queueNicknameUpdatesForAllPlayers());
        this.RTP_ENABLED_WORLDS.changeEvent.register(configuredWorldIdStrings -> ManagerLocator.getInstance().runAndQueue("RTP_ENABLED_WORLDS", server -> {
            Set worldIds = server.method_29435().stream().map(class_5321::method_29177).collect(Collectors.toSet());
            EssentialCommands.LOGGER.info("Possible world ids: {}", (Object)String.join((CharSequence)",", worldIds.stream().map(class_2960::toString).toList()));
            List<class_2960> configuredWorldIds = configuredWorldIdStrings.stream().map(class_2960::method_60654).toList();
            EssentialCommands.LOGGER.info("Configured `rtp_enabled_worlds` world ids: {}", (Object)String.join((CharSequence)",", configuredWorldIds.stream().map(class_2960::toString).toList()));
            Set validConfiguredWorldIds = configuredWorldIdStrings.stream().map(class_2960::method_60654).filter(worldIds::contains).collect(Collectors.toSet());
            List<class_2960> invalidConfiguredWorldIds = configuredWorldIdStrings.stream().map(class_2960::method_60654).filter(v -> !worldIds.contains(v)).toList();
            if (invalidConfiguredWorldIds.size() > 0) {
                EssentialCommands.LOGGER.warn("{} configured `rtp_enabled_worlds` world ids were invalid: {}", (Object)invalidConfiguredWorldIds.size(), (Object)String.join((CharSequence)",", invalidConfiguredWorldIds.stream().map(class_2960::toString).toList()));
            } else {
                EssentialCommands.LOGGER.info("All configured `rtp_enabled_worlds` world ids are valid.");
            }
            this.validRtpWorldIds.clear();
            server.method_29435().stream().filter(k -> validConfiguredWorldIds.contains(k.method_29177())).forEach(this.validRtpWorldIds::add);
            EssentialCommands.refreshConfigSnapshot();
        }));
    }

    @NotNull
    public Set<class_5321<class_1937>> getValidRtpWorldKeys() {
        return this.validRtpWorldIds;
    }

    public static <T> T getValueSafe(@NotNull Option<T> option, T defaultValue) {
        try {
            return (T)option.getValue();
        }
        catch (Exception ex) {
            EssentialCommands.LOGGER.error((Object)ex);
            return defaultValue;
        }
    }
}

