/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.slider;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import dev.isxander.yacl3.gui.controllers.slider.ISliderController;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class SliderControllerElement
extends ControllerWidget<ISliderController<?>> {
    private final double min;
    private final double max;
    private final double interval;
    private float interpolation;
    private Dimension<Integer> sliderBounds;
    private boolean mouseDown = false;

    public SliderControllerElement(ISliderController<?> option, YACLScreen screen, Dimension<Integer> dim, double min, double max, double interval) {
        super(option, screen, dim);
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.setDimension(dim);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.calculateInterpolation();
    }

    @Override
    protected void drawHoveredControl(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_25294(this.sliderBounds.x().intValue(), this.sliderBounds.centerY() - 1, this.sliderBounds.xLimit().intValue(), this.sliderBounds.centerY().intValue(), -1);
        graphics.method_25294(this.sliderBounds.x() + 1, this.sliderBounds.centerY().intValue(), this.sliderBounds.xLimit() + 1, this.sliderBounds.centerY() + 1, -12566464);
        graphics.method_25294(this.getThumbX() - this.getThumbWidth() / 2 + 1, this.sliderBounds.y() + 1, this.getThumbX() + this.getThumbWidth() / 2 + 1, this.sliderBounds.yLimit() + 1, -12566464);
        graphics.method_25294(this.getThumbX() - this.getThumbWidth() / 2, this.sliderBounds.y().intValue(), this.getThumbX() + this.getThumbWidth() / 2, this.sliderBounds.yLimit().intValue(), -1);
    }

    @Override
    protected void drawValueText(class_332 graphics, int mouseX, int mouseY, float delta) {
        GuiUtils.pushPose(graphics);
        if (this.isHovered()) {
            GuiUtils.translate2D(graphics, -((float)(this.sliderBounds.width() + 6) + (float)this.getThumbWidth() / 2.0f), 0.0f);
        }
        super.drawValueText(graphics, mouseX, mouseY, delta);
        GuiUtils.popPose(graphics);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isAvailable() || button != 0 || !this.sliderBounds.isPointInside((int)mouseX, (int)mouseY)) {
            return false;
        }
        this.mouseDown = true;
        this.setValueFromMouse(mouseX);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isAvailable() || button != 0 || !this.mouseDown) {
            return false;
        }
        this.setValueFromMouse(mouseX);
        return true;
    }

    public void incrementValue(double amount) {
        ((ISliderController)this.control).setPendingValue(class_3532.method_15350((double)(((ISliderController)this.control).pendingValue() + this.interval * amount), (double)this.min, (double)this.max));
        this.calculateInterpolation();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        if (!this.isAvailable() || !this.method_25405(mouseX, mouseY) || !class_437.method_25442() && !class_437.method_25441()) {
            return false;
        }
        this.incrementValue(vertical);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isAvailable() && this.mouseDown) {
            this.playDownSound();
        }
        this.mouseDown = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.focused) {
            return false;
        }
        switch (keyCode) {
            case 263: {
                this.incrementValue(-1.0);
                break;
            }
            case 262: {
                this.incrementValue(1.0);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY) || this.mouseDown;
    }

    protected void setValueFromMouse(double mouseX) {
        double value = (mouseX - (double)this.sliderBounds.x().intValue()) / (double)this.sliderBounds.width().intValue() * ((ISliderController)this.control).range();
        ((ISliderController)this.control).setPendingValue(this.roundToInterval(value));
        this.calculateInterpolation();
    }

    protected double roundToInterval(double value) {
        return class_3532.method_15350((double)(this.min + this.interval * (double)Math.round(value / this.interval)), (double)this.min, (double)this.max);
    }

    @Override
    protected int getHoveredControlWidth() {
        return this.sliderBounds.width() + this.getUnhoveredControlWidth() + 6 + this.getThumbWidth() / 2;
    }

    protected void calculateInterpolation() {
        this.interpolation = class_3532.method_15363((float)((float)((((ISliderController)this.control).pendingValue() - ((ISliderController)this.control).min()) * 1.0 / ((ISliderController)this.control).range())), (float)0.0f, (float)1.0f);
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int trackWidth = dim.width() / 3;
        if (this.optionNameString.isEmpty()) {
            trackWidth = dim.width() / 2;
        }
        this.sliderBounds = Dimension.ofInt(dim.xLimit() - this.getXPadding() - this.getThumbWidth() / 2 - trackWidth, dim.centerY() - 5, trackWidth, 10);
    }

    protected int getThumbX() {
        return (int)((float)this.sliderBounds.x().intValue() + (float)this.sliderBounds.width().intValue() * this.interpolation);
    }

    protected int getThumbWidth() {
        return 4;
    }
}

