/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.structure_pool.api;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabric_extras.structure_pool.internal.StructurePoolExtension;
import net.fabric_extras.structure_pool.mixin.StructurePoolAccessor;
import net.minecraft.class_2960;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class StructurePoolAPI {
    private static final ArrayList<StructurePoolConfig.Entry> pendingInjections = new ArrayList();
    private static final class_5321<class_5497> EMPTY_PROCESSOR_LIST_KEY = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)class_2960.method_60656((String)"empty"));
    public static HashMap<class_2960, HashMap<class_2960, SpawnPerk>> spawnLimitations = new HashMap();

    public static void injectAll(StructurePoolConfig config) {
        pendingInjections.addAll(config.entries);
    }

    public static void processInjections(MinecraftServer server) {
        for (StructurePoolConfig.Entry entry : pendingInjections) {
            class_2960 pooldId = class_2960.method_60654((String)entry.pool);
            for (StructurePoolConfig.Entry.Structure structure : entry.structures) {
                class_2960 structureId = class_2960.method_60654((String)structure.id);
                StructurePoolAPI.injectIntoStructurePool(server, pooldId, structureId, structure.weight);
                if (structure.limit <= 0) continue;
                StructurePoolAPI.limitSpawn(pooldId, structureId, structure.limit);
            }
        }
        pendingInjections.clear();
    }

    public static void injectIntoStructurePool(MinecraftServer server, class_2960 poolId, class_2960 structureId, int weight) {
        class_6880.class_6883 emptyProcessorList = server.method_30611().method_30530(class_7924.field_41247).method_40290(EMPTY_PROCESSOR_LIST_KEY);
        Optional poolGetter = server.method_30611().method_30530(class_7924.field_41249).method_17966(poolId);
        if (poolGetter.isEmpty()) {
            System.err.println("StructurePool API: cannot add to " + String.valueOf(poolId) + " as it cannot be found!");
            return;
        }
        class_3785 pool = (class_3785)poolGetter.get();
        ObjectArrayList<class_3784> pieceList = ((StructurePoolAccessor)pool).getElements();
        class_3781 piece = (class_3781)class_3784.method_30435((String)structureId.toString(), (class_6880)emptyProcessorList).apply(class_3785.class_3786.field_16687);
        ((StructurePoolExtension)pool).remember((class_3784)piece, structureId);
        ArrayList<Pair<class_3784, Integer>> list = new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)pool).getElementCounts());
        list.add((Pair<class_3784, Integer>)Pair.of((Object)piece, (Object)weight));
        ((StructurePoolAccessor)pool).setElementCounts(list);
        for (int i = 0; i < weight; ++i) {
            pieceList.add((Object)piece);
        }
    }

    public static void limitSpawn(class_2960 poolId, class_2960 structureId, int limit) {
        if (!spawnLimitations.containsKey(poolId)) {
            spawnLimitations.put(poolId, new HashMap());
        }
        spawnLimitations.get(poolId).put(structureId, new SpawnPerk(limit));
    }

    public record SpawnPerk(int limit) {
    }
}

