/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.animation.dispatch.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.common.animation.AzAnimator;
import mod.azure.azurelibarmor.common.animation.AzAnimatorAccessor;
import mod.azure.azurelibarmor.common.animation.dispatch.AzDispatchSide;
import mod.azure.azurelibarmor.common.animation.dispatch.command.AzControllerCommandBuilder;
import mod.azure.azurelibarmor.common.animation.dispatch.command.AzRootCommandBuilder;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.AzAction;
import mod.azure.azurelibarmor.common.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelibarmor.common.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelibarmor.common.network.packet.AzItemStackDispatchCommandPacket;
import mod.azure.azurelibarmor.common.platform.Services;
import mod.azure.azurelibarmor.common.util.codec.AzListStreamCodec;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_9139;

public record AzCommand(List<AzAction> actions) {
    public static final class_9139<class_2540, AzCommand> CODEC = class_9139.method_56434(new AzListStreamCodec<AzAction>(AzAction.CODEC), AzCommand::actions, AzCommand::new);

    public static AzRootCommandBuilder rootBuilder() {
        return new AzRootCommandBuilder();
    }

    public static AzControllerCommandBuilder controllerBuilder() {
        return new AzControllerCommandBuilder();
    }

    public static AzCommand compose(Collection<AzCommand> commands) {
        if (commands.isEmpty()) {
            throw new IllegalArgumentException("Attempted to compose an empty collection of commands.");
        }
        if (commands.size() == 1) {
            return commands.iterator().next();
        }
        return new AzCommand(commands.stream().flatMap(command -> command.actions().stream()).toList());
    }

    public static AzCommand compose(AzCommand first, AzCommand second, AzCommand ... others) {
        ArrayList<AzCommand> allCommands = new ArrayList<AzCommand>();
        allCommands.add(first);
        allCommands.add(second);
        Collections.addAll(allCommands, others);
        return AzCommand.compose(allCommands);
    }

    public static AzCommand create(String controllerName, String animationName) {
        return AzCommand.create(controllerName, animationName, AzPlayBehaviors.PLAY_ONCE, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public static AzCommand create(String controllerName, String animationName, AzPlayBehavior playBehavior) {
        return AzCommand.create(controllerName, animationName, playBehavior, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public static AzCommand create(String controllerName, String animationName, AzPlayBehavior playBehavior, float startTickOffset, float animationSpeed, float transitionLength, float freezeTickOffset, float repeatXTimes, boolean isReversing) {
        return AzCommand.controllerBuilder().playSequence(controllerName, sequenceBuilder -> sequenceBuilder.queue(animationName, props -> props.withPlayBehavior(playBehavior))).setFreezeTickOffset(controllerName, freezeTickOffset).setStartTickOffset(controllerName, startTickOffset).setSpeed(controllerName, animationSpeed).setRepeatAmount(controllerName, repeatXTimes).setReverseAnimation(controllerName, isReversing).build();
    }

    public static AzCommand createRoot(String animationName, AzPlayBehavior playBehavior, float startTickOffset, float animationSpeed, float transitionLength, float freezeTickOffset, float repeatXTimes, boolean isReversing) {
        return AzCommand.rootBuilder().playSequence(sequenceBuilder -> sequenceBuilder.queue(animationName, props -> props.withPlayBehavior(playBehavior))).setFreezeTickOffset(freezeTickOffset).setTransitionSpeed(transitionLength).setStartTickOffset(startTickOffset).setSpeed(animationSpeed).setRepeatAmount(repeatXTimes).setReverseAnimation(isReversing).build();
    }

    public void sendForItem(class_1297 entity, class_1799 itemStack) {
        if (entity.method_37908().method_8608()) {
            this.dispatchFromClient(itemStack);
        } else {
            UUID uuid = (UUID)itemStack.method_57824(AzureLib.AZ_ID.get());
            if (uuid == null) {
                AzureLib.LOGGER.warn("Could not find item stack UUID during dispatch. Did you forget to register an identity for the item? Item: {}, Item Stack: {}", (Object)itemStack.method_7909(), (Object)itemStack);
                return;
            }
            AzItemStackDispatchCommandPacket packet = new AzItemStackDispatchCommandPacket(uuid, this);
            Services.NETWORK.sendToTrackingEntityAndSelf(packet, entity);
        }
    }

    private <T> void dispatchFromClient(T animatable) {
        AzAnimator animator = AzAnimatorAccessor.getOrNull(animatable);
        if (animator != null) {
            this.actions.forEach(action -> action.handle(AzDispatchSide.CLIENT, animator));
        }
    }
}

