/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.setworldspawnpoint.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.setworldspawnpoint_common_forge.events.WorldSpawnEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeWorldSpawnEvent {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.CreateSpawnPosition e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        if (WorldSpawnEvent.onWorldLoad((ServerLevel)level, (ServerLevelData)level.getLevelData())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        WorldSpawnEvent.onPlayerRespawn(null, (ServerPlayer)player, false);
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent e) {
        WorldSpawnEvent.onEntityJoin(e.getLevel(), e.getEntity());
    }
}

