/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.MicrowaveBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;

public class MicrowaveBlockEntity
extends ElectricityModuleProcessingLootBlockEntity
implements IPowerSwitch,
IHomeControlDevice,
ILevelAudio,
class_1275,
class_1737 {
    public static final int[] INPUT_SLOTS = new int[]{0};
    public static final int[] OUTPUT_SLOTS = new int[]{1};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROCESS_TIME = 2;
    public static final int DATA_MAX_PROCESS_TIME = 3;
    public static final double MAX_AUDIO_DISTANCE = class_3532.method_33723((double)3.5);
    protected final class_243 audioPosition;
    protected boolean enabled;
    protected boolean processing;
    protected final class_3913 data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.powered ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.processingTime, value -> {
            this.processingTime = value;
        });
        builder.add(3, () -> this.totalProcessingTime, value -> {
            this.totalProcessingTime = value;
        });
    });

    public MicrowaveBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.MICROWAVE.get(), pos, state, (class_3956<? extends ProcessingRecipe>)((class_3956)ModRecipeTypes.MICROWAVE_HEATING.get()));
    }

    public MicrowaveBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, class_3956<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, 2, recipeType);
        this.audioPosition = pos.method_46558();
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "microwave", new Object[0]);
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        return Services.MENU.createMicrowaveMenu(windowId, playerInventory, (class_1263)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    public boolean canProcess() {
        return super.canProcess() && this.enabled;
    }

    @Override
    public void onOpen(class_1937 level, class_2338 pos, class_2680 state) {
        level.method_8396(null, this.field_11867, (class_3414)ModSounds.BLOCK_MICROWAVE_OPEN.get(), class_3419.field_15245, 1.0f, 0.9f + 0.1f * level.field_9229.method_43057());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(class_1937 level, class_2338 pos, class_2680 state) {
        level.method_8396(null, this.field_11867, (class_3414)ModSounds.BLOCK_MICROWAVE_CLOSE.get(), class_3419.field_15245, 1.0f, 0.9f + 0.1f * level.field_9229.method_43057());
        this.setDoorState(state, false);
    }

    private void setDoorState(class_2680 state, boolean open) {
        class_1937 level = this.method_10997();
        if (level != null) {
            level.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)MicrowaveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.method_5431();
        BlockEntityHelper.sendCustomUpdate((class_2586)this, class_2586::method_16887);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10573("Enabled", 1)) {
            this.enabled = tag.method_10577("Enabled");
        }
        if (tag.method_10573("Processing", 1)) {
            this.processing = tag.method_10577("Processing");
        }
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10556("Enabled", this.enabled);
        tag.method_10556("Processing", this.processing);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        tag.method_10556("Enabled", this.enabled);
        tag.method_10556("Processing", this.processing);
        BlockEntityHelper.saveCustomName(tag, this.method_5797(), provider);
        return tag;
    }

    @Override
    public class_2338 getDevicePos() {
        return this.field_11867;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.method_5431();
        this.syncDataToTrackingClients();
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.method_5431();
        this.syncDataToTrackingClients();
    }

    @Override
    public class_2561 getDeviceName() {
        if (this.method_16914()) {
            return this.method_5797();
        }
        return this.method_17823();
    }

    @Override
    public class_3414 getSound() {
        return (class_3414)ModSounds.BLOCK_MICROWAVE_FAN.get();
    }

    @Override
    public class_3419 getSource() {
        return class_3419.field_15245;
    }

    @Override
    public class_243 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.isNodePowered() && this.processing && this.enabled && !this.method_11015();
    }

    @Override
    public int getAudioHash() {
        return this.field_11867.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    @Override
    public void moduleTick(class_1937 level) {
        super.moduleTick(level);
        if (!level.field_9236) {
            boolean processing = this.processTick();
            if (this.processing != processing) {
                this.processing = processing;
                this.syncDataToTrackingClients();
            }
        } else {
            AudioManager.get().playLevelAudio(this);
        }
    }

    public void method_7683(class_1662 contents) {
        for (class_1799 stack : this.items) {
            contents.method_7400(stack);
        }
    }
}

