/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mixin;

import com.mojang.authlib.GameProfile;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.mixin.GameProfileCacheAccessor;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.minecraft.class_156;
import net.minecraft.class_2631;
import net.minecraft.class_3312;
import net.minecraft.class_7497;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2631.class})
public abstract class SkullBlockEntityMixin {
    @Inject(method={"fetchProfileByName"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fetchProfileByName(String name, class_7497 services, CallbackInfoReturnable<CompletableFuture<Optional<GameProfile>>> cir) {
        if (name == null) {
            return;
        }
        Optional<GameProfile> profileOpt = Optional.empty();
        class_3312.class_3313 gameProfileInfo = ((GameProfileCacheAccessor)services.comp_840()).getProfilesByName().get(name.toLowerCase(Locale.ROOT));
        if (gameProfileInfo != null) {
            profileOpt = Optional.of(gameProfileInfo.method_14519());
        }
        SkullBlockEntityMixin.skinrestorer$replaceSkin(profileOpt, cir);
    }

    @Inject(method={"fetchProfileById"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fetchProfileById(UUID id, class_7497 services, BooleanSupplier cacheUninitialized, CallbackInfoReturnable<CompletableFuture<Optional<GameProfile>>> cir) {
        if (id == null) {
            return;
        }
        Optional profileOpt = services.comp_840().method_14512(id);
        SkullBlockEntityMixin.skinrestorer$replaceSkin(profileOpt, cir);
    }

    @Unique
    private static void skinrestorer$replaceSkin(Optional<GameProfile> profileOpt, CallbackInfoReturnable<CompletableFuture<Optional<GameProfile>>> cir) {
        if (SkinRestorer.getMinecraftServer() == null) {
            return;
        }
        if (profileOpt.isEmpty()) {
            return;
        }
        GameProfile profile = PlayerUtils.cloneGameProfile(profileOpt.get());
        if (SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
            cir.setReturnValue(CompletableFuture.supplyAsync(() -> {
                SkinValue skin = SkinRestorer.getSkinStorage().getSkin(profile.getId(), false);
                PlayerUtils.applyRestoredSkin(profile, skin.value());
                return Optional.of(profile);
            }, class_156.method_18349()));
        }
    }
}

