/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class Result<S, E> {
    private final S successValue;
    private final E errorValue;

    private Result(S successValue, E errorValue) {
        if (successValue == null && errorValue == null) {
            throw new IllegalArgumentException("Cannot create result of null values");
        }
        this.successValue = successValue;
        this.errorValue = errorValue;
    }

    public static <S, E> Result<S, E> success(@NotNull S successValue) {
        return new Result<S, Object>(successValue, null);
    }

    public static <S, E> Result<S, E> error(@NotNull E errorValue) {
        return new Result<Object, E>(null, errorValue);
    }

    public static <S, E> Result<Optional<S>, E> ofNullable(S successValue) {
        return Result.success(Optional.ofNullable(successValue));
    }

    public S getSuccessValue() {
        return this.successValue;
    }

    public E getErrorValue() {
        return this.errorValue;
    }

    public boolean isSuccess() {
        return this.successValue != null;
    }

    public boolean isError() {
        return this.errorValue != null;
    }

    public <N> Result<N, E> map(Function<S, N> mapper) {
        if (this.successValue == null) {
            return new Result<Object, E>(null, this.errorValue);
        }
        return new Result<N, E>(mapper.apply(this.successValue), this.errorValue);
    }

    public <N> Result<S, N> mapError(Function<E, N> mapper) {
        if (this.errorValue == null) {
            return new Result<S, Object>(this.successValue, null);
        }
        return new Result<S, N>(this.successValue, mapper.apply(this.errorValue));
    }

    public Optional<S> toOptional() {
        return Optional.ofNullable(this.successValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return Objects.equals(this.successValue, result.successValue) && Objects.equals(this.errorValue, result.errorValue);
    }

    public int hashCode() {
        return Objects.hash(this.successValue, this.errorValue);
    }
}

