/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Experience;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.impl.ExperienceImpl;
import net.puffish.skillsmod.impl.SkillImpl;
import net.puffish.skillsmod.util.PointSources;

public class CategoryImpl
implements Category {
    private final class_2960 categoryId;

    public CategoryImpl(class_2960 categoryId) {
        this.categoryId = categoryId;
    }

    @Override
    public class_2960 getId() {
        return this.categoryId;
    }

    @Override
    public Optional<Experience> getExperience() {
        if (SkillsMod.getInstance().hasExperience(this.categoryId).orElseThrow().booleanValue()) {
            return Optional.of(new ExperienceImpl(this.categoryId));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Skill> getSkill(String skillId) {
        if (SkillsMod.getInstance().hasSkill(this.categoryId, skillId)) {
            return Optional.of(new SkillImpl(this, skillId));
        }
        return Optional.empty();
    }

    @Override
    public Stream<Skill> streamSkills() {
        return SkillsMod.getInstance().getSkills(this.categoryId).orElseThrow().stream().map(skillId -> new SkillImpl(this, (String)skillId));
    }

    @Override
    public Stream<Skill> streamUnlockedSkills(class_3222 player) {
        return SkillsMod.getInstance().getUnlockedSkills(player, this.categoryId).orElseThrow().stream().map(skillId -> new SkillImpl(this, (String)skillId));
    }

    @Override
    public void openScreen(class_3222 player) {
        SkillsMod.getInstance().openScreen(player, Optional.of(this.categoryId));
    }

    @Override
    public void unlock(class_3222 player) {
        SkillsMod.getInstance().unlockCategory(player, this.categoryId);
    }

    @Override
    public void lock(class_3222 player) {
        SkillsMod.getInstance().lockCategory(player, this.categoryId);
    }

    @Override
    public boolean isUnlocked(class_3222 player) {
        return SkillsMod.getInstance().isCategoryUnlocked(player, this.categoryId).orElseThrow();
    }

    @Override
    public void erase(class_3222 player) {
        SkillsMod.getInstance().eraseCategory(player, this.categoryId);
    }

    @Override
    public void resetSkills(class_3222 player) {
        SkillsMod.getInstance().resetSkills(player, this.categoryId);
    }

    @Override
    public Stream<class_2960> streamPointsSources(class_3222 player) {
        return SkillsMod.getInstance().getPointsSources(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getPoints(class_3222 player, class_2960 source) {
        return SkillsMod.getInstance().getPoints(player, this.categoryId, source).orElseThrow();
    }

    @Override
    public void setPoints(class_3222 player, class_2960 source, int count) {
        SkillsMod.getInstance().setPoints(player, this.categoryId, source, count, false);
    }

    @Override
    public void addPoints(class_3222 player, class_2960 source, int count) {
        SkillsMod.getInstance().addPoints(player, this.categoryId, source, count, false);
    }

    @Override
    public void setPointsSilently(class_3222 player, class_2960 source, int count) {
        SkillsMod.getInstance().setPoints(player, this.categoryId, source, count, true);
    }

    @Override
    public void addPointsSilently(class_3222 player, class_2960 source, int count) {
        SkillsMod.getInstance().addPoints(player, this.categoryId, source, count, true);
    }

    @Override
    public int getSpentPoints(class_3222 player) {
        return SkillsMod.getInstance().getSpentPoints(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getPointsTotal(class_3222 player) {
        return SkillsMod.getInstance().getPointsTotal(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getPointsLeft(class_3222 player) {
        return SkillsMod.getInstance().getPointsLeft(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getExtraPoints(class_3222 player) {
        return this.getPointsTotal(player);
    }

    @Override
    public void setExtraPoints(class_3222 player, int count) {
        this.addExtraPoints(player, count - this.getExtraPoints(player));
    }

    @Override
    public void addExtraPoints(class_3222 player, int count) {
        this.addPoints(player, PointSources.COMMANDS, count);
    }
}

